<?php
namespace App\Exports;

use App\Models\Member;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class AttendanceExport implements FromView
{
    protected $startDate, $endDate;

    public function __construct($startDate, $endDate)
    {
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function view(): View
    {
        $members = Member::with(['attendances', 'mandalDetails', 'statusDetails'])->get();

        // Get all distinct attendance dates in range
        $attendanceDates = \App\Models\Attendance::whereBetween('date', [$this->startDate, $this->endDate])
            ->distinct()
            ->pluck('date');

        return view('exports.attendance', [
            'members' => $members,
            'attendanceDates' => $attendanceDates
        ]);
    }
}
