<?php

namespace App\Exports;

use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GenderMemberExport implements FromCollection, WithHeadings
{
    protected $gender;

    public function __construct($gender = null)
    {
        $this->gender = $gender;
    }

    public function collection()
    {
        $query = Member::with(['mandalDetails', 'statusDetails']);

        if ($this->gender) {
            $query->where('gender', $this->gender);
        }

        return $query->get()->map(function ($member) {
            return [
                $member->id,
                $member->first_name,
                $member->last_name,
                $member->gender,
                $member->number,
                $member->dob,
                $member->age,
                $member->address,
                $member->city,
                $member->Karyakarta,
                optional($member->mandalDetails)->title,
                optional($member->statusDetails)->title,
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Member ID',
            'First Name',
            'Last Name',
            'Gender',
            'Mobile',
            'DOB',
            'Age',
            'Address',
            'City',
            'Karyakarta',
            'Mandal',
            'Status',
        ];
    }
}
