<?php
namespace App\Exports;

use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class KaryakartaMemberExport implements FromCollection, WithHeadings
{
    protected $karyakarta;

    public function __construct($karyakarta = null)
    {
        $this->karyakarta = $karyakarta;
    }

    public function collection()
    {
        $query = Member::with(['mandalDetails', 'statusDetails']);

        if ($this->karyakarta) {
            $query->where('Karyakarta', $this->karyakarta);
        }

        return $query->get()->map(function ($member) {
            return [
                $member->id,
                $member->first_name,
                $member->last_name,
                $member->gender,
                $member->number,
                $member->dob,
                \Carbon\Carbon::parse($member->dob)->age ?? '-',
                $member->address,
                $member->city,
                $member->Karyakarta,
                optional($member->mandalDetails)->title,
                optional($member->statusDetails)->title,
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Member ID',
            'First Name',
            'Last Name',
            'Gender',
            'Mobile',
            'DOB',
            'Age',
            'Address',
            'City',
            'Karyakarta',
            'Mandal',
            'Status',
        ];
    }
}
