<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use PDF;
use Illuminate\Support\Facades\App;
use App\Models\Member;

class WhatsappController extends Controller
{
    public function storeAndSharePdf($id)
    {
        $member = Member::findOrFail($id);
    
        // Generate PDF
        $pdf = Pdf::loadView('pdf.card', compact('member'));
    
        // Define file path
        $filePath = 'pdfs/membership_card_' . $id . '.pdf';
    
        // Store the PDF in public storage
        Storage::put('public/' . $filePath, $pdf->output());
    
        // ✅ Get the correct public URL
        $pdfUrl = asset('storage/' . $filePath);
    
        // ✅ Log the URL for debugging
        \Log::info('Generated PDF URL:', ['url' => $pdfUrl]);
    
        // Send WhatsApp document
        $response = Http::post('http://wa.rigelpay.in/api/v1/sendDocument', [
            "key" => "e4613dac2c8e428e9b327cd79c61669a",
            "to" => $member->number,
            "url" => $pdfUrl,
            "filename" => "membership_card_{$id}.pdf"
        ]);
    
        // Parse response
        $responseData = $response->json();
    
        if ($response->successful() && isset($responseData['ErrorCode'])) {
            if ($responseData['ErrorCode'] === '000') {
                \Log::info('WhatsApp document sent', [
                    'member_id' => $id,
                    'number' => $member->number,
                    'api_reference' => $responseData['Data'] ?? null
                ]);
                return redirect()->back()->with('success', 'WhatsApp document sent successfully!');
            } else {
                \Log::error('WhatsApp API business error', [
                    'member_id' => $id,
                    'error_code' => $responseData['ErrorCode'],
                    'error_message' => $responseData['ErrorMessage']
                ]);
                return redirect()->back()->with('error', 'API Error: ' . $responseData['ErrorMessage']);
            }
        }
    
        \Log::error('WhatsApp API failed', [
            'member_id' => $id,
            'status' => $response->status(),
            'response' => $response->body()
        ]);
        return redirect()->back()->with('error', 'Failed to communicate with WhatsApp API');
    }
    
    public function sendMessage($id)
    {
        $member = Member::find($id);

        if (!$member || !$member->number) {
            \Log::error('WhatsApp send failed - Member or number not found', ['member_id' => $id]);
            return redirect()->back()->with('error', 'User phone number not found.');
        }

        // Store the PDF and get its public URL
        $pdfUrl = $this->storeAndSharePdf($id);

        // Send WhatsApp message with PDF
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post('http://wa.rigelpay.in/api/v1/sendDocument', json_encode([
            "key" => "e4613dac2c8e428e9b327cd79c61669a",
            "to" => $member->number,
            "url" => $pdfUrl,
            "filename" => "Membership_Card.pdf"
        ]));

        // Parse JSON response
        $responseData = $response->json();

        if ($response->successful() && isset($responseData['ErrorCode']) && $responseData['ErrorCode'] === '000') {
            \Log::info('WhatsApp document sent', [
                'member_id' => $id,
                'number' => $member->number,
                'api_reference' => $responseData['Data'] ?? null
            ]);
            return redirect()->back()->with('success', 'WhatsApp document sent successfully!');
        } else {
            \Log::error('WhatsApp API error', [
                'member_id' => $id,
                'error_code' => $responseData['ErrorCode'] ?? 'Unknown',
                'error_message' => $responseData['ErrorMessage'] ?? 'No message returned'
            ]);
            return redirect()->back()->with('error', 'Failed to send WhatsApp document.');
        }
    }
}
