<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'phone_number' => 'required|string',
            'password' => 'required|string',
        ]);
    
        $user = User::where('phone_number', $request->phone_number)->first();
    
        if (!$user || !Hash::check($request->password, $user->password)) {
            return response()->json(['error' => 'Invalid phone number or password'], 401);
        }
    
        $token = $user->createToken('LaravelToken')->plainTextToken;
    
        return response()->json([
            'user' => $user,
            'token' => $token,
        ], 200);
    }
    

    public function logout(Request $request)
    {
        $user = $request->user();
        if ($user) {
            $user->currentAccessToken()->delete();
            return response()->json(['message' => 'Logged out successfully']);
        }
        
        return response()->json(['message' => 'No user logged in'], 400);
    }
}
