<?php

namespace App\Http\Controllers;

use App\Models\Attendance;
use Illuminate\Http\Request;
use TCG\Voyager\Http\Controllers\VoyagerBaseController;

class AttendanceBreadController extends VoyagerBaseController
{
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required|date',
            'member_id' => 'required|exists:members,id',
            'sabha_id' => 'required|exists:sabhas,id',
        ]);

        // Duplicate check
        $exists = Attendance::where('member_id', $request->member_id)
            ->where('sabha_id', $request->sabha_id)
            ->where('date', $request->date)
            ->exists();

        if ($exists) {
            return redirect()->back()->with([
                'message'    => 'Attendance already exists for this member and sabha on this date.',
                'alert-type' => 'error',
            ]);
        }

        // Call Voyager default store logic
        return parent::store($request);
    }
}
