@extends('voyager::master')



@section('content')

<div class="container">

    <h2>Attendance Report</h2>

    <form method="GET" action="{{ route('attendance.report') }}" class="mb-4">

        <div class="row">

            <div class="col-md-4">

                <label>Start Date</label>

                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">

            </div>

            <div class="col-md-4">

                <label>End Date</label>

                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">

            </div>

            <div class="col-md-4">

                <label>Member</label>

                <select name="member_id" class="form-control">

                    <option value="">All Members</option>

                    @foreach($members as $member)

                    <option value="{{ $member->id }}" {{ request('member_id') == $member->id ? 'selected' : '' }}>
                        {{ $member->first_name . ' ' . $member->last_name }}
                    </option>

                    @endforeach

                </select>

            </div>

        </div>

        <button type="submit" class="btn btn-success mt-3">Filter</button>

        <a href="{{ route('attendance.report') }}" class="btn btn-danger mt-3">Clear Filter</a>

    </form>



    <table class="table table-bordered">

        <thead>

            <tr>

                <th>Date</th>

                <th>Member Name</th>

            </tr>

        </thead>

        <tbody>

            @foreach($attendances as $attendance)

            <tr>

                <td>{{ $attendance->date }}</td>

                <td>{{ $attendance->memberDetails->first_name ?? 'N/A' }}</td>

            </tr>

            @endforeach

        </tbody>

    </table>

    

    {{ $attendances->links() }}

</div>

@endsection

