@extends('voyager::master')

@section('content')
<div class="container">
    <h2 style="color: #fff;">Attendance Report - All Members (Date-wise)</h2>

    <form method="GET" action="{{ route('admin.reports.attendance') }}" class="mb-4">
        <div class="row">
            <div class="col-md-3">
                <label style="color: #fff;">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
            </div>
            <div class="col-md-3">
                <label style="color: #fff;">End Date</label>
                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
            </div>
        </div>
        <div class="mt-3">
            <button type="submit" class="btn btn-success">Filter</button>
            <a href="{{ route('admin.reports.attendance') }}" class="btn btn-danger">Clear</a>

            {{-- ✅ Export Button --}}
            <a href="{{ route('admin.reports.attendance.export', ['start_date' => request('start_date'), 'end_date' => request('end_date')]) }}" class="btn btn-primary">
                Export to Excel
            </a>
        </div>
    </form>

    @if(count($members) > 0)
        <div class="table-responsive mt-4">
            <table class="table table-bordered" style="background: #fff;">
                <thead>
                    <tr>
                        <th>SR No</th>
                        <th>Member ID</th>
                        <th>Name</th>
                        <th>Gender</th>
                        <th>Mobile</th>
                        <th>Age</th>
                        <th>Karyakarta</th>
                        <th>Mandal</th>
                        <th>Status</th>
                        @foreach($attendanceDates as $date)
                            <th>{{ \Carbon\Carbon::parse($date)->format('d-m-Y') }}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @foreach($members as $index => $member)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $member->id }}</td>
                            <td>{{ $member->first_name }} {{ $member->last_name }}</td>
                            <td>{{ $member->gender }}</td>
                            <td>{{ $member->number }}</td>
                            <td>{{ $member->age }} years</td>
                            <td>{{ $member->Karyakarta }}</td>
                            <td>{{ $member->mandalDetails->title ?? 'N/A' }}</td>
                            <td>{{ $member->statusDetails->title ?? 'N/A' }}</td>
                            @foreach($attendanceDates as $date)
                                @php
                                    $present = $member->attendances->firstWhere('date', $date);
                                @endphp
                                <td>{{ $present ? 'Present' : 'Absent' }}</td>
                            @endforeach
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <p class="mt-4">No attendance data found for the selected filters.</p>
    @endif
</div>
@endsection
