@extends('voyager::master')

@section('content')
<div class="container">
    <h2 style="color: #fff;">Member Report by Karyakarta</h2>

    <form method="GET" action="{{ route('admin.reports.karyakarta') }}" class="mb-4">
    <div class="row">
        <div class="col-md-4">
            <label style="color: #fff;">Select Karyakarta</label>
            <select name="karyakarta" class="form-control">
                <option value="">All</option>
                @foreach($karyakartaOptions as $option)
                    <option value="{{ $option }}" {{ request('karyakarta') == $option ? 'selected' : '' }}>
                        {{ $option }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>
    <button type="submit" class="btn btn-success mt-3">Filter</button>
    <a href="{{ route('admin.reports.karyakarta') }}" class="btn btn-danger mt-3">Clear</a>

    <!-- ✅ Export Button -->
    <a href="{{ route('admin.reports.karyakarta.export', ['karyakarta' => request('karyakarta')]) }}"
       class="btn btn-primary mt-3">
        Export to Excel
    </a>
</form>


    @if(count($selectedMembers) > 0)
    <div class="table-responsive mt-4">
        <table class="table table-bordered table-striped" style="background: #fff;">
            <thead>
                <tr>
                    <th>SR No</th>
                    <th>Member ID</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Member Image</th>
                    <th>Gender</th>
                    <th>Number</th>
                    <th>DOB</th>
                    <th>Age</th>
                    <th>Address</th>
                    <th>City</th>
                    <th>Karyakarta</th>
                    <th>Mandal</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($selectedMembers as $index => $member)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $member->id }}</td>
                    <td>{{ $member->first_name }}</td>
                    <td>{{ $member->last_name }}</td>
                    <td>
                        @if($member->member_image)
                            <img src="{{ asset('storage/' . $member->member_image) }}" width="60">
                        @else
                            No Image
                        @endif
                    </td>
                    <td>{{ $member->gender }}</td>
                    <td>{{ $member->number }}</td>
                    <!-- <td>{{ $member->dob }}</td> -->
                     <td>{{ \Carbon\Carbon::parse($member->dob)->format('d-m-Y') }}</td>
                    <td>{{ \Carbon\Carbon::parse($member->dob)->age ?? '-' }} years</td>
                    <td>{{ $member->address }}</td>
                    <td>{{ $member->city }}</td>
                    <td>{{ $member->Karyakarta }}</td>
                    <td>{{ $member->mandalDetails->title ?? 'N/A' }}</td>
                    <td>{{ $member->statusDetails->title ?? 'N/A' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @else
        <p class="mt-4">No member data found.</p>
    @endif
</div>
@endsection
