<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Attendance Sabha Report</title>
</head>
<body>
    <h3>Attendance Report - All Members</h3>
    <p>
        <strong>Start Date:</strong> {{ \Carbon\Carbon::parse($startDate)->format('d-m-Y') }} |
        <strong>End Date:</strong> {{ \Carbon\Carbon::parse($endDate)->format('d-m-Y') }}
    </p>

    <table border="1">
        <thead>
            <tr>
                <th>SR. No</th>
                <th>Member ID</th>
                <th>First Name</th>
                <th>Last Name</th>
                <th>Gender</th>
                <th>Mobile Number</th>
                <th>Age</th>
                <th>Karyakarta</th>
                <th>Mandal</th>
                <th>Status</th>
                <th>No. of Sabha Organised</th>
                <th>No. of Sabha Attended</th>
                <th>Sabha Names Attended</th>
                <th>% of Sabha Attended</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($reportData as $row)
                <tr>
                    <td>{{ $row['sr_no'] }}</td>
                    <td>{{ $row['member_id'] }}</td>
                    <td>{{ $row['first_name'] }}</td>
                    <td>{{ $row['last_name'] }}</td>
                    <td>{{ $row['gender'] }}</td>
                    <td style="mso-number-format:'\@';">{{ $row['mobile_no'] }}</td>
                    <td>{{ $row['age'] }}</td>
                    <td>{{ $row['karyakarta'] }}</td>
                    <td>{{ $row['mandal'] }}</td>
                    <td>{{ $row['status'] }}</td>
                    <td>{{ $row['organised'] }}</td>
                    <td>{{ $row['attended'] }}</td>
                    <td>{{ $row['attended_titles'] }}</td>
                    <td>{{ $row['percentage'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
