<?php

namespace App\Actions;

use TCG\Voyager\Actions\AbstractAction;

class CardAction extends AbstractAction
{
    public function getTitle()
    {
        return 'Card';
    }

    public function getIcon()
    {
        return 'voyager-credit-cards'; // Use any Voyager icon
    }

    public function getPolicy()
    {
        return 'browse';
    }

    public function getAttributes()
    {
        return [
            'class' => 'btn btn-sm btn-dark',
        ];
    }

    public function getDefaultRoute()
    {
        return route('admin.members'); // Adjust this route as needed
    }

    public function getRoute($slug)
    {
        return route('admin.members.card', $this->data->id);
    }

    public function shouldActionDisplayOnRow($data)
    {
        return true; // Always show the button
    }

    // ✅ This function ensures the button is only shown on the "members" table
    public function shouldActionDisplayOnDataType()
    {
        return $this->dataType->slug == 'members'; // Change 'members' to your table slug
    }
}
