<?php

namespace App\Exports;

use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class AgeMemberExport implements FromCollection, WithHeadings
{
    protected $startAge;
    protected $endAge;

    public function __construct($startAge = null, $endAge = null)
    {
        $this->startAge = $startAge;
        $this->endAge = $endAge;
    }

    public function collection()
    {
        $query = Member::with(['mandalDetails', 'statusDetails']);

        if ($this->startAge !== null) {
            $query->where('age', '>=', $this->startAge);
        }

        if ($this->endAge !== null) {
            $query->where('age', '<=', $this->endAge);
        }

        return $query->get()->map(function ($member) {
            return [
                $member->id,
                $member->first_name,
                $member->last_name,
                $member->gender,
                $member->number,
                $member->dob,
                $member->age,
                $member->address,
                $member->city,
                $member->Karyakarta,
                optional($member->mandalDetails)->title,
                optional($member->statusDetails)->title,
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Member ID',
            'First Name',
            'Last Name',
            'Gender',
            'Mobile',
            'DOB',
            'Age',
            'Address',
            'City',
            'Karyakarta',
            'Mandal',
            'Status',
        ];
    }
}
