<?php
namespace App\Exports;

use App\Models\Member;
use App\Models\Attendance;
use App\Models\Sabha;
use Carbon\Carbon;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class AttendanceSabhaExport implements FromView
{
    protected $startDate;
    protected $endDate;

    public function __construct($startDate, $endDate)
    {
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function view(): View
    {
        $members = Member::with(['mandalDetails', 'statusDetails'])->get();
        $reportData = [];

        foreach ($members as $index => $member) {
            $age = $member->dob ? Carbon::parse($member->dob)->age : null;

            $organisedCount = Sabha::whereBetween('date', [$this->startDate, $this->endDate])->count();

            $attendedSabhaIds = Attendance::where('member_id', $member->id)
                ->whereBetween('created_at', [$this->startDate, $this->endDate])
                ->pluck('sabha_id');

            $attendedCount = $attendedSabhaIds->count();
            $attendedTitles = Sabha::whereIn('id', $attendedSabhaIds)->pluck('title')->implode(', ');
            $percentage = $organisedCount > 0 ? round(($attendedCount / $organisedCount) * 100, 2) . '%' : '0%';

            $reportData[] = [
                'sr_no' => $index + 1,
                'member_id' => $member->id,
                'first_name' => $member->first_name,
                'last_name' => $member->last_name,
                'gender' => $member->gender,
                'mobile_no' => $member->number,
                'age' => $age,
                'karyakarta' => $member->Karyakarta,
                'mandal' => $member->mandalDetails->title ?? 'N/A',
                'status' => $member->statusDetails->title ?? 'N/A',
                'organised' => $organisedCount,
                'attended' => $attendedCount,
                'attended_titles' => $attendedTitles,
                'percentage' => $percentage,
            ];
        }

        return view('exports.attendance_sabha', [
            'reportData' => $reportData,
            'startDate' => $this->startDate,
            'endDate' => $this->endDate
        ]);
    }
}
