<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Sabha;

class Attendance extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'member_id',
        'sabha_id',
    ];

    //hidden
    protected $hidden = [
        'created_at',
        'updated_at',
        'sabha_id',
        'member_id',
    ];
    // Relationship with Member
    public function memberDetails()
    {
        return $this->belongsTo(Member::class, 'member_id', 'id');
    }

    public function sabhaDetails()
    {
        return $this->belongsTo(Sabha::class, 'sabha_id', 'id');
    }
    public static function getAttendanceReportData($startDate, $endDate)
    {
        $query = self::with(['memberDetails.mandalDetails', 'memberDetails.statusDetails', 'sabhaDetails']);

        if ($startDate && $endDate) {
            $query->whereBetween('date', [$startDate, $endDate]);
        }

        $attendances = $query->get();

        $reportData = [];

        foreach ($attendances->groupBy('member_id') as $index => $group) {
            $member = $group->first()->memberDetails;
            $attendedTitles = $group->pluck('sabhaDetails.title')->unique()->implode(', ');
            $attendedCount = $group->count();
            $organisedCount = 4; // replace with actual count logic

            $percentage = $organisedCount > 0
                ? round(($attendedCount / $organisedCount) * 100, 2) . '%'
                : '0%';

            $reportData[] = [
                'sr_no' => $index + 1,
                'member_id' => $member->id,
                'first_name' => $member->first_name,
                'last_name' => $member->last_name,
                'gender' => $member->gender,
                'mobile_no' => $member->mobile_no,
                'age' => $member->age,
                'karyakarta' => $member->karyakarta ? 'Yes' : 'No',
                'mandal' => optional($member->mandalDetails)->title,
                'status' => optional($member->statusDetails)->title,
                'organised' => $organisedCount,
                'attended' => $attendedCount,
                'attended_titles' => $attendedTitles,
                'percentage' => $percentage,
            ];
        }

        return $reportData;
}

}
