<?php

namespace App\Models;
use App\Models\Attendance;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Member extends Model
{
    use HasFactory;

    protected $table = 'members';

    public $timestamps = false;

    protected $fillable = [
        'first_name',
        'last_name',
        'member_image',
        'number',
        'gender',
        'dob',
        'age',
        'address',
        'city',
        'mandal',
        'status',
        'Karyakarta',
    ];


    public function setNumberAttribute($value)
    {
        if (!str_starts_with($value, '+91')) {
            $this->attributes['number'] = '+91' . ltrim($value, '0');
        } else {
            $this->attributes['number'] = $value;
        }
    }    
    
    
    public function attendances()
    {
        return $this->hasMany(Attendance::class, 'member_id');
    }
    // Relationship with MemberStatus
    public function statusDetails()
    {
        return $this->belongsTo(MemberStatus::class, 'status');
    }
    
    public function attendancesDetails()
    {
        return $this->belongsTo(Attendance::class);
    }

    // Relationship with Mandal
    public function mandalDetails()
    {
        return $this->belongsTo(Mandal::class, 'mandal');
    }

    // public function getAgeAttribute()
    // {
    //     // return \Carbon\Carbon::parse($this->dob)->age;
    //     $age = \Carbon\Carbon::parse($this->dob)->age;
    //     return "{$age}"; // returns a string
    // }
    // public function getAgeAttribute($value)
    // {
    //     return $value; // returns the full string from the DB
    // }
    public function getAgeAttribute()
    {
        if (!$this->dob) {
            return null;
        }

        $dob = \Carbon\Carbon::parse($this->dob);
        $now = \Carbon\Carbon::now();

        $diff = $dob->diff($now);

        return sprintf(
            '%02d years %02d months %02d days',
            $diff->y,
            $diff->m,
            $diff->d
        );
    }

    
}
