<?php

namespace App\Widgets;

use Arrilot\Widgets\AbstractWidget;
use App\Models\Mandal;

class MandalMemberDimmer extends AbstractWidget
{
    protected $config = [];

    public function run()
    {
        $mandals = Mandal::all();
        $rows = [];
        $sr = 1;
        $totalMale = 0;
        $totalFemale = 0;
        $totalAll = 0;

        foreach ($mandals as $mandal) {
            $male = $mandal->members()->where('gender', 'Male')->count();
            $female = $mandal->members()->where('gender', 'Female')->count();
            $total = $male + $female;
            $rows[] = [
                'sr' => $sr++,
                'mandal' => $mandal->title,
                'male' => $male,
                'female' => $female,
                'total' => $total,
            ];
            $totalMale += $male;
            $totalFemale += $female;
            $totalAll += $total;
        }

        return view('widgets.mandal_member_dimmer', [
            'rows' => $rows,
            'totalMale' => $totalMale,
            'totalFemale' => $totalFemale,
            'totalAll' => $totalAll,
            'config' => $this->config,
        ]);
    }

    public function shouldBeDisplayed()
    {
        return true;
    }
}