<?php $__env->startSection('page_title', __('voyager::generic.'.(isset($dataTypeContent->id) ? 'edit' : 'add')).' '.$dataType->display_name_singular); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-content container-fluid">
        <?php echo $__env->make('voyager::alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-bordered">
                    <form role="form" class="form-edit-add" action="<?php echo e(isset($dataTypeContent->id) ? route('voyager.'.$dataType->slug.'.update', $dataTypeContent->id) : route('voyager.'.$dataType->slug.'.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php if(isset($dataTypeContent->id)): ?> <?php echo e(method_field("PUT")); ?> <?php endif; ?>
                        <?php echo e(csrf_field()); ?>


                        <div class="panel-body">
                            <!-- Member Search Section -->
                            <div class="form-group">
                                <label for="member_search">Search Member (by ID or Phone)</label>
                                <div class="input-group">
                                    <!-- <input type="text" class="form-control" id="member_search" placeholder="Enter member ID or phone number"> -->
                                    <input type="text" class="form-control" id="member_search" placeholder="Enter member ID, phone, or name">

                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" id="search_member">
                                            <i class="voyager-search"></i> Search
                                        </button>
                                    </div>
                                </div>
                                <div id="search_results" class="mt-2" style="display:none; max-height: 300px; overflow-y: auto; border: 1px solid #ddd; border-radius: 4px;">
                                    <div class="list-group" id="member_results"></div>
                                </div>
                            </div>

                            <!-- Selected Member Display -->
                            <div class="form-group" id="selected_member_container" style="display:none;">
                                <label>Selected Member</label>
                                <div class="card bg-light">
                                    <div class="card-body p-2">
                                        <h5 class="mb-1" id="selected_member_name"></h5>
                                        <p class="text-muted small mb-0" id="selected_member_details"></p>
                                        <input type="hidden" name="member_id" id="selected_member_id">
                                    </div>
                                </div>
                            </div>

                            <!-- Sabha Selection -->
                            <div class="form-group">
                                <label for="sabha_id">Select Sabha</label>
                                <select class="form-control" name="sabha_id" id="sabha_id" required>
                                    <option value="" disabled selected>Select</option>
                                    <?php $__currentLoopData = App\Models\Sabha::orderBy('date', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sabha): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option 
                                            value="<?php echo e($sabha->id); ?>" 
                                            data-date="<?php echo e(\Carbon\Carbon::parse($sabha->date)->format('Y-m-d')); ?>"
                                            <?php echo e(isset($dataTypeContent->sabha_id) && $dataTypeContent->sabha_id == $sabha->id ? 'selected' : ''); ?>>
                                            <?php echo e($sabha->title); ?> (<?php echo e(\Carbon\Carbon::parse($sabha->date)->format('Y-m-d')); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <!-- Date Field -->
                            <!-- Hidden Date Field -->
                            <input type="hidden" name="date" id="date" value="<?php echo e($dataTypeContent->date ?? ''); ?>">

                        </div>

                        <div class="panel-footer">
                            <button type="submit" class="btn btn-primary save"><?php echo e(__('voyager::generic.save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Search functionality
            $('#search_member').click(function() {
                const searchTerm = $('#member_search').val().trim();
                
                if(!searchTerm) {
                    toastr.error('Please enter ID or phone number');
                    return;
                }

                $.ajax({
                    url: '<?php echo e(route("voyager.members.search")); ?>',
                    method: 'POST',
                    data: { 
                        search: searchTerm,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(response) {
                        const results = $('#member_results');
                        results.empty();
                        
                        if(response.length > 0) {
                            response.forEach(function(member) {
                                results.append(`
                                    <a href="#" class="list-group-item list-group-item-action select-member" 
                                    data-id="${member.id}"
                                    data-name="${member.first_name} ${member.last_name}"
                                    data-mandal="${member.mandal_details ? member.mandal_details.title : 'No Mandal'}">
                                        ${member.first_name} ${member.last_name} (ID: ${member.id}) - [${member.mandal_details ? member.mandal_details.title : 'No Mandal'}]
                                    </a>
                                `);
                            });
                            $('#search_results').show();
                        } else {
                            results.append('<div class="list-group-item">No members found</div>');
                            $('#search_results').show();
                        }
                    }
                });
            });

            // Member selection
            $(document).on('click', '.select-member', function(e) {
                e.preventDefault();
                const memberId = $(this).data('id');
                const memberName = $(this).data('name');
                const memberMandal = $(this).data('mandal');
                
                $('#selected_member_id').val(memberId);
                $('#selected_member_name').text(memberName);
                $('#selected_member_details').text(`Mandal: ${memberMandal}`);
                $('#selected_member_container').show();
                $('#search_results').hide();
            });


            // Auto-update attendance date when sabha changes
            $('#sabha_id').on('change', function() {
                const selectedDate = $(this).find(':selected').data('date');
                if (selectedDate) {
                    $('#date').val(selectedDate);
                }
            });
            <?php if(isset($dataTypeContent->sabha_id)): ?>
                $('#sabha_id').trigger('change');
            <?php endif; ?>


            // For edit mode - pre-select member if exists
            <?php if(isset($dataTypeContent->member_id)): ?>
                $.ajax({
                    url: '<?php echo e(route("voyager.members.get", ["id" => "__ID__"])); ?>'.replace('__ID__', <?php echo e($dataTypeContent->member_id); ?>),
                    method: 'GET',
                    success: function(member) {
                        if(member) {
                            $('#selected_member_id').val(member.id);
                            $('#selected_member_name').text(member.first_name + ' ' + member.last_name);
                            $('#selected_member_details').text('Mandal: ' + (member.mandal_details ? member.mandal_details.title : 'No Mandal'));
                            $('#selected_member_container').show();
                        }
                    }
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('voyager::master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u241073935/domains/click4demos.co.in/public_html/attendance/resources/views/vendor/voyager/attendances/edit-add.blade.php ENDPATH**/ ?>