<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Membership Card</title>
<!-- <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #fbe6d3;
        }

        .id-card {
            width: 320px;
            background: #fbe6d3;
            border-radius: 10px;
            padding: 20px 15px;
            text-align: center;
            font-family: 'Arial', sans-serif;
            margin: 20px auto;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
            position: relative;
        }

        .top-logo {
            width: 100px;
            margin: 0 auto 10px;
        }

        .title {
            font-size: 20px;
            font-weight: bold;
            color: #7a3e13;
            /* margin-bottom: 10px; */
        }

        .profile-circle {
            width: 120px;
            height: 120px;
            background-color: #a84900;
            border-radius: 50%;
            margin: 15px auto;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .profile-pic {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

    /* .profile-circle {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        overflow: hidden;
        position: absolute;
    }

    .profile-pic {
        width: 100%;
        height: 100%;
        object-fit: cover;
        position: absolute;
        top: 0;
        left: 0;
        display: flex;
        align-items: center;
        justify-content: center;
    } */


        .member-name {
            font-size: 15px;
            font-weight: bold;
            color: #7a3e13;
            /* margin-top: 10px; */
        }

        .member-id {
            font-size: 12px;
            color: #7a3e13;
            /* margin-top: 4px; */
        }

        .mandal-name {
            font-size: 14px;
            font-weight: bold;
            color: #7a3e13;
            margin-top: 8px;
        }

        .decor-img {
            margin: 10px auto;
            width: 100%;
            max-width: 300px;
        }

        .qr-code {
            margin-top: 10px;
            width: 140px;
            background: #fbe6d3;
            padding: 6px;
            border: 1px solid #7a3e13;
            border-radius: 6px;
        }
</style> -->
<style>
    body {
        background-color: #fbe6d3;
    }

    .id-card {
        width: 320px;
        background: #fbe6d3;
        border-radius: 10px;
        padding: 20px 15px;
        text-align: center;
        font-family: 'Arial', sans-serif;
        margin: 20px auto;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        position: relative;
    }

    .top-logo {
        width: 100px;
        margin: 0 auto 10px;
    }

    .title {
        font-size: 20px;
        font-weight: bold;
        color: #7a3e13;
        /* margin-bottom: 10px; */
    }

    /* .profile-circle {
        width: 120px;
        height: 120px;
        background-color: #a84900;
        border-radius: 50%;
        margin: 15px auto;
        overflow: hidden;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .profile-pic {
        width: 100%;
        height: 100%;
        object-fit: cover;
    } */


.profile-pic {
    width: 100%;
    height: 100%;
    /* aspect-ratio: 1 / 1; Keep it square and responsive */
    object-fit: cover;
    border-radius: 50%; /* Make the image itself circular */
}



    .profile-circle {
    width: 120px;
    height: 120px;
    border-radius: 0;
    margin: 15px auto;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
    background: none;
}

    .member-name {
        font-size: 15px;
        font-weight: bold;
        color: #7a3e13;
        /* margin-top: 10px; */
    }

    .member-id {
        font-size: 12px;
        color: #7a3e13;
        /* margin-top: 4px; */
    }

    .mandal-name {
        font-size: 14px;
        font-weight: bold;
        color: #7a3e13;
        margin-top: 8px;
    }

    .decor-img {
        margin: 10px auto;
        width: 100%;
        max-width: 300px;
    }

    .qr-code {
        margin-top: 10px;
        width: 140px;
        background: #fbe6d3;
        padding: 6px;
        border: 1px solid #7a3e13;
        border-radius: 6px;
    }

    .print-button {
        margin-top: 15px;
        background: #a84900;
        color: white;
        border-radius: 5px;
        padding: 8px 12px;
        text-decoration: none;
        border: none;
        cursor: pointer;
    }
</style>
</head>
<body>
    <div class="id-card">
        <!-- Top Logo -->
        <img src="<?php echo e(public_path('storage/' . setting('admin.icon_image'))); ?>" alt="Brand Logo" class="top-logo">

        <!-- Profile Image -->
        <div class="profile-circle">
            <img src="<?php echo e(public_path('storage/' . $member->member_image)); ?>" class="profile-pic" alt="Member Image">
        </div>
        <!-- <div class="profile-circle" style="background-image: url('<?php echo e(public_path('storage/' . $member->member_image)); ?>'); background-size: cover; background-position: center;">
        </div> -->


        <!-- Member Name -->
        <div class="title"><?php echo e($member->first_name); ?> <?php echo e($member->last_name); ?></div>

        <!-- Member ID -->
        <div class="member-id">ID: <?php echo e($member->id); ?></div>

        <!-- Mandal Name -->
        <div class="member-name">
            <?php echo e($member->mandalDetails->title ?? 'MANDAL NAME'); ?>

        </div>

        <!-- Decorative Line -->
        <img src="<?php echo e(public_path('storage/decor-line.png')); ?>" alt="Decoration" class="decor-img">

        <!-- QR Code -->
        <img src="data:image/svg+xml;base64,<?php echo e(base64_encode(
            QrCode::format('svg')
                ->size(200)
                ->margin(0)
                ->color(138, 49, 0)
                ->generate(url('/api/scan-attendance?member_id=' . $member->id))
        )); ?>" class="qr-code" alt="QR Code">

        <!-- Optional Line Below -->
        <img src="<?php echo e(public_path('storage/line.png')); ?>" alt="Line" style="margin-top: 10px; max-width: 200px;">
    </div>
</body>
</html>
<?php /**PATH /home/u241073935/domains/click4demos.co.in/public_html/attendance/resources/views/pdf/card.blade.php ENDPATH**/ ?>