<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 style="color: #fff;">Member Report by Gender</h2>

    <form method="GET" action="<?php echo e(route('admin.reports.gender')); ?>" class="mb-4">
    <div class="row">
        <div class="col-md-4">
            <label style="color: #fff;">Select Gender</label>
            <select name="gender" class="form-control">
                <option value="">All Genders</option>
                <option value="Male" <?php echo e(request('gender') == 'Male' ? 'selected' : ''); ?>>Male</option>
                <option value="Female" <?php echo e(request('gender') == 'Female' ? 'selected' : ''); ?>>Female</option>
            </select>
        </div>
    </div>
    <button type="submit" class="btn btn-success mt-3">Filter</button>
    <a href="<?php echo e(route('admin.reports.gender')); ?>" class="btn btn-danger mt-3">Clear</a>

    <!-- ✅ Export Button -->
    <a href="<?php echo e(route('admin.reports.gender.export', ['gender' => request('gender')])); ?>" class="btn btn-primary mt-3">
        Export to Excel
    </a>
</form>


    <?php if(count($selectedMembers) > 0): ?>
        <table class="table table-bordered table-striped" style="background: #fff;">
            <thead>
                <tr>
                    <th>SR No</th>
                    <th>Member ID</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Member Image</th>
                    <th>Gender</th>
                    <th>Number</th>
                    <th>Dob</th>
                    <th>Age</th>
                    <th>Address</th>
                    <th>City</th>
                    <th>Karyakarta</th>
                    <th>Mandal</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $selectedMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td> <!-- SR No -->
                    <td><?php echo e($member->id); ?></td> <!-- Member ID -->
                    <td><?php echo e($member->first_name); ?></td>
                    <td><?php echo e($member->last_name); ?></td>
                    <td>
                        <?php if($member->member_image): ?>
                            <img src="<?php echo e(asset('storage/' . $member->member_image)); ?>" width="60">
                        <?php else: ?>
                            No Image
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($member->gender); ?></td>
                    <td><?php echo e($member->number); ?></td>
                    <!-- <td><?php echo e($member->dob); ?></td> -->
                     <td><?php echo e(\Carbon\Carbon::parse($member->dob)->format('d-m-Y')); ?></td>
                    <td><?php echo e($member->age); ?> years</td>
                    <td><?php echo e($member->address); ?></td>
                    <td><?php echo e($member->city); ?></td>
                    <td><?php echo e($member->Karyakarta); ?></td>
                    <td><?php echo e(optional($member->mandalDetails)->title ?? 'N/A'); ?></td>
                    <td><?php echo e(optional($member->statusDetails)->title ?? 'N/A'); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>No member data found.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('voyager::master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u241073935/domains/click4demos.co.in/public_html/attendance/resources/views/admin/reports/gender.blade.php ENDPATH**/ ?>