<?php
namespace App\Exports;

use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class StatusMemberExport implements FromCollection, WithHeadings
{
    protected $status;

    public function __construct($status = null)
    {
        $this->status = $status;
    }

    public function collection()
    {
        $query = Member::with(['mandalDetails', 'statusDetails']);

        if ($this->status) {
            $query->where('status', $this->status);
        }

        return $query->get()->map(function ($member) {
            return [
                $member->id,
                $member->first_name,
                $member->last_name,
                $member->gender,
                $member->number,
                $member->dob,
                $member->age,
                $member->address,
                $member->city,
                $member->Karyakarta,
                optional($member->mandalDetails)->title,
                optional($member->statusDetails)->title,
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Member ID',
            'First Name',
            'Last Name',
            'Gender',
            'Mobile',
            'DOB',
            'Age',
            'Address',
            'City',
            'Karyakarta',
            'Mandal',
            'Status',
        ];
    }
}
