<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Member;
use App\Models\Attendance;
use App\Models\Sabha;
use Illuminate\Http\Request;

class CustomAttendanceController extends Controller
{
    public function create()
    {
        return view('admin.attendances.custom-create', [
            'sabhas' => Sabha::all()
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'member_id' => 'required|exists:members,id',
            'date' => 'required|date',
            'sabha_id' => 'required|exists:sabhas,id'
        ]);

        Attendance::create($request->only(['member_id', 'date', 'sabha_id']));

        return redirect()->back()->with([
            'message' => 'Attendance added successfully!',
            'alert-type' => 'success'
        ]);
    }

    public function searchMember(Request $request)
    {
        $query = Member::query();
        
        if(is_numeric($request->search)) {
            $query->where('id', $request->search)
                  ->orWhere('number', 'LIKE', '%'.$request->search.'%');
        } else {
            $query->where('number', 'LIKE', '%'.$request->search.'%');
        }

        return response()->json(
            $query->with('mandalDetails')
                 ->limit(10)
                 ->get()
                 ->map(function($member) {
                     return [
                         'id' => $member->id,
                         'text' => sprintf('%s %s (%s) - %s', 
                             $member->first_name,
                             $member->last_name,
                             $member->mandalDetails->title ?? 'No Mandal',
                             $member->number
                         )
                     ];
                 })
        );
    }
}