<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Attendance;
use App\Models\Member;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Models\Mandal;
// use App\Models\Member;
use App\Models\MemberStatus;
use App\Models\Sabha;
use App\Models\Status;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\AttendanceSabhaExport;
use App\Exports\AttendanceExport; 
use App\Exports\ZeroAttendanceExport; // ✅ CORRECT



class ReportController extends Controller
{
    public function index(Request $request)
    {
        $query = Attendance::query()->with('memberDetails');

        // Apply filters if provided
        if ($request->filled('start_date') && $request->filled('end_date')) {
            $query->whereBetween('date', [$request->start_date, $request->end_date]);
        }

        if ($request->filled('member_id')) {
            $query->where('member_id', $request->member_id);
        }

        $attendances = $query->paginate(10);
        $members = Member::all();

        return view('admin.attendance-report', compact('attendances', 'members'));
    }


    public function membersReport(Request $request)
    {
        $members = Member::all(); // For dropdown
        $selectedMembers = [];

        if ($request->filled('member_id')) {
            $member = Member::find($request->member_id);
            if ($member) {
                $selectedMembers[] = $member;
            }
        } else {
            $selectedMembers = Member::all(); // Show all members by default
        }

        return view('admin.reports.members', compact('members', 'selectedMembers'));
    }

    public function mandalReport(Request $request)
    {
        $mandals = Mandal::all();

        $members = Member::with(['mandalDetails', 'statusDetails'])
            ->when($request->mandal, function ($query) use ($request) {
                $query->where('mandal', $request->mandal);
            })
            ->get();

        // return view('vendor.voyager.reports.mandal', compact('mandals', 'members'));
        return view('admin.reports.mandal', compact('mandals', 'members'));
    }

    public function genderReport(Request $request)
    {
        $selectedMembers = [];

        if ($request->filled('gender')) {
            $selectedMembers = Member::where('gender', $request->gender)->get();
        } else {
            $selectedMembers = Member::all(); // Show all by default
        }

        return view('admin.reports.gender', compact('selectedMembers'));
    }

    // public function ageReport(Request $request)
    // {
    //     // Fetch members with relationships
    //     $members = Member::with(['mandalDetails', 'statusDetails'])->get();

    //     // Calculate age
    //     $members = $members->map(function ($member) {
    //         $member->age = $member->dob ? Carbon::parse($member->dob)->age : null;
    //         return $member;
    //     });

    //     // Filter by age range
    //     $selectedMembers = $members->filter(function ($member) use ($request) {
    //         if (is_null($member->age)) return false;

    //         $start = $request->start_age;
    //         $end = $request->end_age;

    //         if ($start && $end) {
    //             return $member->age >= $start && $member->age <= $end;
    //         } elseif ($start) {
    //             return $member->age >= $start;
    //         } elseif ($end) {
    //             return $member->age <= $end;
    //         }

    //         return true;
    //     });

    //     return view('admin.reports.age', compact('selectedMembers'));
    // }


// public function ageReport(Request $request)
// {
//     $start = (int) $request->start_age;
//     $end = (int) $request->end_age;

//     // Fetch members and calculate age
//     $members = Member::with(['mandalDetails', 'statusDetails'])->get()->map(function ($member) {
//         $member->age = $member->dob ? Carbon::parse($member->dob)->diffInYears(now()) : null;
//         return $member;
//     });

//     // Filter by exact age range (only between start and end)
//     $filteredMembers = $members->filter(function ($member) use ($start, $end) {
//         if (is_null($member->age)) return false;

//         return $member->age >= $start && $member->age <= $end;
//     });

//     return view('admin.reports.age', [
//         'selectedMembers' => $filteredMembers,
//         'start_age' => $start,
//         'end_age' => $end,
//     ]);
// }

public function ageReport(Request $request)
{
    $start = $request->has('start_age') ? (int) $request->start_age : null;
    $end = $request->has('end_age') ? (int) $request->end_age : null;

    // Fetch members and calculate age
    $members = Member::with(['mandalDetails', 'statusDetails'])->get()->map(function ($member) {
        $member->age = $member->dob ? Carbon::parse($member->dob)->diffInYears(now()) : null;
        return $member;
    });

    // Filter only if both ages are provided
    if (!is_null($start) && !is_null($end)) {
        $members = $members->filter(function ($member) use ($start, $end) {
            return !is_null($member->age) && $member->age >= $start && $member->age <= $end;
        });
    }

    return view('admin.reports.age', [
        'selectedMembers' => $members,
        'start_age' => $start,
        'end_age' => $end,
    ]);
}


    public function karyakartaReport(Request $request)
    {
        // Dropdown options: just "Yes" and "No"
        $karyakartaOptions = ['Yes', 'No'];

        $members = Member::all(); // All members
        $selectedMembers = [];

        if ($request->filled('karyakarta')) {
            $selectedMembers = Member::where('Karyakarta', $request->karyakarta)->get();
        } else {
            $selectedMembers = Member::all(); // Show all members by default
        }

        return view('admin.reports.karyakarta', compact('members', 'selectedMembers', 'karyakartaOptions'));
    }

    public function statusReport(Request $request)
    {
        $statusOptions = MemberStatus::all();

        $query = Member::with(['statusDetails', 'mandalDetails']);

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        $selectedMembers = $query->get();

        return view('admin.reports.status_report', compact('selectedMembers', 'statusOptions'));
    }


// public function attendanceSabhaReport(Request $request)
// {
//     $startDate = $request->input('start_date');
//     $endDate = $request->input('end_date');

//     // Fallback to today's date if not provided
//     if (!$startDate) {
//         $startDate = Carbon::today()->format('Y-m-d');
//     }
//     if (!$endDate) {
//         $endDate = Carbon::today()->format('Y-m-d');
//     }

//     // Total sabhas organised between dates
//     $totalSabhas = DB::table('sabhas')
//         ->whereBetween('date', [$startDate, $endDate])
//         ->count();

//     // Get all members
//     $members = DB::table('members')->get();

//     // For each member, count attended sabhas in the date range
//     $reportData = [];
//     foreach ($members as $index => $member) {
//         $attendedCount = DB::table('attendances')
//             ->join('sabhas', 'attendances.sabha_id', '=', 'sabhas.id')
//             ->where('attendances.member_id', $member->id)
//             ->whereBetween('sabhas.date', [$startDate, $endDate])
//             ->count();

//         $percentage = ($totalSabhas > 0) ? round(($attendedCount / $totalSabhas) * 100, 2) : 0;

//         $reportData[] = [
//             'sr_no' => $index + 1,
//             'member_id' => $member->id,
//             'first_name' => $member->first_name,
//             'last_name' => $member->last_name,
//             'gender' => $member->gender,
//             'mobile_no' => $member->number,
//             'age' => $member->dob ? Carbon::parse($member->dob)->age : 'N/A',
//             'karyakarta' => $member->Karyakarta,
//             'mandal' => $member->mandal ?? 'N/A',
//             'status' => $member->status ?? 'N/A',
//             'organised' => $totalSabhas,
//             'attended' => $attendedCount,
//             'percentage' => $percentage . '%',
//         ];
//     }

//     return view('admin.reports.attendance_sabha', compact('startDate', 'endDate', 'reportData'));
// }

// public function attendanceSabhaReport(Request $request)
// {
    
//     $startDate = $request->input('start_date') ?? Carbon::today()->format('Y-m-d');
//     $endDate = $request->input('end_date') ?? Carbon::today()->format('Y-m-d');

//     // Fetch all sabhas between date range
//     $sabhas = DB::table('sabhas')
//         ->whereBetween('date', [$startDate, $endDate])
//         ->get();

//     $totalSabhas = $sabhas->count();

//     // Fetch all members
//     $members = DB::table('members')->get();

//     $reportData = [];

//     foreach ($members as $index => $member) {
//         // Count sabhas attended by this member
//         $attendedSabhas = DB::table('attendances')
//             ->join('sabhas', 'attendances.sabha_id', '=', 'sabhas.id')
//             ->where('attendances.member_id', $member->id)
//             ->whereBetween('sabhas.date', [$startDate, $endDate])
//             ->pluck('sabhas.title')
//             ->toArray();

//         $attendedCount = count($attendedSabhas);
//         $percentage = ($totalSabhas > 0) ? round(($attendedCount / $totalSabhas) * 100, 2) : 0;

//         $reportData[] = [
//             'sr_no' => $index + 1,
//             'member_id' => $member->id,
//             'first_name' => $member->first_name,
//             'last_name' => $member->last_name,
//             'gender' => $member->gender,
//             'mobile_no' => $member->number,
//             'age' => $member->dob ? Carbon::parse($member->dob)->age : 'N/A',
//             'karyakarta' => $member->Karyakarta ?? 'No',
//             'mandal' => $member->mandal ?? 'N/A',
//             'status' => $member->status ?? 'N/A',
//             'organised' => $totalSabhas,
//             'attended' => $attendedCount,
//             'attended_titles' => implode(', ', $attendedSabhas),
//             'percentage' => $percentage . '%',
//         ];
//     }

//     return view('admin.reports.attendance_sabha', compact('startDate', 'endDate', 'reportData'));
// }


// public function attendanceSabhaReport(Request $request)
// {
//     $startDate = $request->input('start_date') ?? Carbon::today()->format('Y-m-d');
//     $endDate = $request->input('end_date') ?? Carbon::today()->format('Y-m-d');

//     // Get all sabhas in range
//     $sabhas = DB::table('sabhas')
//         ->whereBetween('date', [$startDate, $endDate])
//         ->get();

//     $totalSabhas = $sabhas->count();

//     // Get all members with mandal and status names
//     $members = DB::table('members')
//         ->leftJoin('mandals', 'members.mandal', '=', 'mandals.id')
//         ->leftJoin('member_statuses', 'members.status', '=', 'member_statuses.id')
//         ->select(
//             'members.*',
//             'mandals.title as mandal_name',
//             'member_statuses.title as status_name'
//         )
//         ->get();

//     $reportData = [];

//     foreach ($members as $index => $member) {
//         // Sabha attended
//         $attendedSabhas = DB::table('attendances')
//             ->join('sabhas', 'attendances.sabha_id', '=', 'sabhas.id')
//             ->where('attendances.member_id', $member->id)
//             ->whereBetween('sabhas.date', [$startDate, $endDate])
//             ->pluck('sabhas.title')
//             ->toArray();

//         $attendedCount = count($attendedSabhas);
//         $percentage = ($totalSabhas > 0) ? round(($attendedCount / $totalSabhas) * 100, 2) : 0;

//         $reportData[] = [
//             'sr_no' => $index + 1,
//             'member_id' => $member->id,
//             'first_name' => $member->first_name,
//             'last_name' => $member->last_name,
//             'gender' => $member->gender,
//             'mobile_no' => $member->number,
//             'age' => $member->dob ? Carbon::parse($member->dob)->age : 'N/A',
//             'karyakarta' => $member->Karyakarta ?? 'No',
//             'mandal' => $member->mandal_name ?? 'N/A',
//             'status' => $member->status_name ?? 'N/A',
//             'organised' => $totalSabhas,
//             'attended' => $attendedCount,
//             'attended_titles' => implode(', ', $attendedSabhas),
//             'percentage' => $percentage . '%',
//         ];
//     }

//     return view('admin.reports.attendance_sabha', compact('startDate', 'endDate', 'reportData'));
// }

public function attendanceSabhaReport(Request $request)
    {
        $startDate = $request->start_date ?? now()->startOfMonth()->toDateString();
        $endDate = $request->end_date ?? now()->endOfMonth()->toDateString();

        $reportData = $this->generateAttendanceReport($startDate, $endDate);

        return view('admin.reports.attendance_sabha', compact('reportData', 'startDate', 'endDate'));
    }
// public function attendanceSabhaReport(Request $request)
// {
//     $startDate = $request->start_date ?? now()->startOfMonth()->toDateString();
//     $endDate = $request->end_date ?? now()->endOfMonth()->toDateString();

//     $members = Member::with(['mandalDetails', 'statusDetails'])->get();

//     $reportData = [];

//     foreach ($members as $index => $member) {
//         $age = $member->dob ? Carbon::parse($member->dob)->age : null;

//         // Count sabha organised (all sabhas in date range)
//         $organisedCount = Sabha::whereBetween('date', [$startDate, $endDate])->count();

//         // Attended sabha IDs by this member
//         $attendedSabhaIds = Attendance::where('member_id', $member->id)
//             ->whereBetween('created_at', [$startDate, $endDate])
//             ->pluck('sabha_id');

//         $attendedCount = $attendedSabhaIds->count();

//         // Get sabha titles attended
//         $attendedTitles = Sabha::whereIn('id', $attendedSabhaIds)->pluck('title')->implode(', ');

//         // Calculate percentage
//         $percentage = $organisedCount > 0 ? round(($attendedCount / $organisedCount) * 100, 2) . '%' : '0%';

//         $reportData[] = [
//             'sr_no' => $index + 1,
//             'member_id' => $member->id,
//             'first_name' => $member->first_name,
//             'last_name' => $member->last_name,
//             'gender' => $member->gender,
//             'mobile_no' => $member->number,
//             'age' => $age,
//             'karyakarta' => $member->Karyakarta,
//             'mandal' => $member->mandalDetails->title ?? 'N/A',
//             'status' => $member->statusDetails->title ?? 'N/A',
//             'organised' => $organisedCount,
//             'attended' => $attendedCount,
//             'attended_titles' => $attendedTitles,
//             'percentage' => $percentage,
//         ];
//     }

//     return view('admin.reports.attendance_sabha', compact('reportData', 'startDate', 'endDate'));
// }

public function exportAttendanceSabha(Request $request)
{
    $startDate = $request->start_date ?? now()->startOfMonth()->toDateString();
    $endDate = $request->end_date ?? now()->endOfMonth()->toDateString();

    return Excel::download(new AttendanceSabhaExport($startDate, $endDate), 'Attendance-Sabha-Report.xlsx');
}
// public function attendanceReport(Request $request)
// {
//     $start = $request->start_date;
//     $end = $request->end_date;
//     $sabhaId = $request->sabha_id;

//     $sabhas = Sabha::all();

//     // Get unique attendance sabha dates between range
//     $attendanceDates = Attendance::when($start && $end, function ($q) use ($start, $end) {
//         $q->whereBetween('sabha_date', [$start, $end]);
//     })
//     ->when($sabhaId, function ($q) use ($sabhaId) {
//         $q->where('sabha_id', $sabhaId);
//     })
//     ->pluck('sabha_date')
//     ->unique()
//     ->sort()
//     ->values();

//     // Get all members with their attendances in date range
//     $members = Attendance_Register::with(['mandalDetails', 'statusDetails', 'attendances' => function ($query) use ($start, $end, $sabhaId) {
//         if ($start && $end) {
//             $query->whereBetween('sabha_date', [$start, $end]);
//         }
//         if ($sabhaId) {
//             $query->where('sabha_id', $sabhaId);
//         }
//     }])->get();

//     // Calculate age
//     foreach ($members as $member) {
//         $member->age = \Carbon\Carbon::parse($member->dob)->age;
//     }

//     return view('vendor.voyager.reports.attendance', [
//         'members' => $members,
//         'sabhas' => $sabhas,
//         'attendanceDates' => $attendanceDates,
//     ]);
// }


// public function attendanceReport(Request $request)
// {
//     $start = $request->start_date;
//     $end = $request->end_date;
//     $sabhaId = $request->sabha_id;

//     // Fetch all sabhas for dropdown
//     $sabhas = Sabha::orderBy('date', 'desc')->get();

//     // Fetch unique sabha_dates from Attendance table based on filters
//     $attendanceDates = Attendance::query()
//         ->when($start && $end, function ($q) use ($start, $end) {
//             $q->whereBetween('date', [$start, $end]);
//         })
//         ->when($sabhaId, function ($q) use ($sabhaId) {
//             $q->where('sabha_id', $sabhaId);
//         })
//         ->pluck('date')
//         ->unique()
//         ->sort()
//         ->values();

//     // Fetch members and their filtered attendances
//     $members = Attendance_Register::with([
//         'mandalDetails',
//         'statusDetails',
//         'attendances' => function ($query) use ($start, $end, $sabhaId) {
//             if ($start && $end) {
//                 $query->whereBetween('sabha_date', [$start, $end]);
//             }
//             if ($sabhaId) {
//                 $query->where('sabha_id', $sabhaId);
//             }
//         }
//     ])->get();

//     // Calculate age for each member
//     foreach ($members as $member) {
//         $member->age = $member->dob ? Carbon::parse($member->dob)->age : null;
//     }

//     return view('vendor.voyager.reports.attendance', [
//         'members' => $members,
//         'sabhas' => $sabhas,
//         'attendanceDates' => $attendanceDates,
//     ]);
// }



// public function attendanceReport(Request $request)
// {
//     $start = $request->start_date;
//     $end = $request->end_date;
//     $sabhaId = $request->sabha_id;

//     // Get all sabhas for dropdown
//     $sabhas = Sabha::orderBy('date', 'desc')->get();

//     // 1. Get distinct attendance dates within the filter
//     $attendanceDates = Attendance::query()
//         ->when($start && $end, function ($q) use ($start, $end) {
//             $q->whereBetween('date', [$start, $end]);
//         })
//         ->when($sabhaId, function ($q) use ($sabhaId) {
//             $q->where('sabha_id', $sabhaId);
//         })
//         ->pluck('date')
//         ->unique()
//         ->sort()
//         ->values();

//     // 2. Get members with their filtered attendances
//     $members = Attendance_Register::with([
//         'mandalDetails',
//         'statusDetails',
//         'attendances' => function ($query) use ($start, $end, $sabhaId) {
//             if ($start && $end) {
//                 $query->whereBetween('date', [$start, $end]);
//             }
//             if ($sabhaId) {
//                 $query->where('sabha_id', $sabhaId);
//             }
//         }
//     ])->get();

//     // 3. Calculate age for each member
//     foreach ($members as $member) {
//         $member->age = $member->dob ? Carbon::parse($member->dob)->age : null;
//     }

//     return view('vendor.voyager.reports.attendance', [
//         'members' => $members,
//         'sabhas' => $sabhas,
//         'attendanceDates' => $attendanceDates,
//     ]);
// }

    // public function attendanceReport(Request $request)
    // {
    //     $start = $request->start_date;
    //     $end = $request->end_date;
    //     $sabhaId = $request->sabha_id;

    //     // Get all sabhas for dropdown
    //     $sabhas = Sabha::orderBy('date', 'desc')->get();

    //     // Get unique sabha dates from attendance table
    //     $attendanceDates = Attendance::query()
    //         ->when($start && $end, function ($q) use ($start, $end) {
    //             $q->whereBetween('date', [$start, $end]);
    //         })
    //         ->when($sabhaId, function ($q) use ($sabhaId) {
    //             $q->where('sabha_id', $sabhaId);
    //         })
    //         ->pluck('date')
    //         ->unique()
    //         ->sort()
    //         ->values();

    //     // Get members and their filtered attendances
    //     $members = Member::with([
    //         'mandalDetails',
    //         'statusDetails',
    //         'attendances' => function ($query) use ($start, $end, $sabhaId) {
    //             if ($start && $end) {
    //                 $query->whereBetween('date', [$start, $end]);
    //             }
    //             if ($sabhaId) {
    //                 $query->where('sabha_id', $sabhaId);
    //             }
    //         }
    //     ])->get();

    //     // Calculate age for each member
    //     foreach ($members as $member) {
    //         $member->age = $member->dob ? Carbon::parse($member->dob)->age : null;
    //     }

    //     return view('vendor.voyager.reports.attendance', [
    //         'members' => $members,
    //         'sabhas' => $sabhas,
    //         'attendanceDates' => $attendanceDates,
    //     ]);
    // }
 public function attendanceReport(Request $request)
    {
        $start = $request->start_date;
        $end = $request->end_date;
        $sabhaId = $request->sabha_id;

        // Get sabha list for dropdown
        $sabhas = Sabha::orderBy('date', 'desc')->get();

        // Get distinct sabha dates from Attendance table
        $attendanceDates = Attendance::query()
            ->when($start && $end, function ($q) use ($start, $end) {
                $q->whereBetween('date', [$start, $end]);
            })
            ->when($sabhaId, function ($q) use ($sabhaId) {
                $q->where('sabha_id', $sabhaId);
            })
            ->pluck('date')
            ->unique()
            ->sort()
            ->values();

        // Get members with attendance records
        $members = Member::with([
            'mandalDetails',
            'statusDetails',
            'attendances' => function ($query) use ($start, $end, $sabhaId) {
                if ($start && $end) {
                    $query->whereBetween('date', [$start, $end]);
                }
                if ($sabhaId) {
                    $query->where('sabha_id', $sabhaId);
                }
            }
        ])->get();

        // Calculate age
        foreach ($members as $member) {
            $member->age = $member->dob ? Carbon::parse($member->dob)->age : null;
        }

        return view('admin.reports.attendance', [
            'members' => $members,
            'sabhas' => $sabhas,
            'attendanceDates' => $attendanceDates,
        ]);
    }



public function exportAttendance(Request $request)
{
    $startDate = $request->start_date ?? now()->startOfMonth()->toDateString();
    $endDate = $request->end_date ?? now()->endOfMonth()->toDateString();

    return Excel::download(new AttendanceExport($startDate, $endDate), 'attendance_report.xlsx');
}






// public function export(Request $request)
// {
//     $startDate = $request->input('start_date');
//     $endDate = $request->input('end_date');

//     return Excel::download(new AttendanceSabhaExport($startDate, $endDate), 'attendance_sabha_report.xlsx');
// }


// public function export(Request $request)
// {
//     $startDate = $request->input('start_date');
//     $endDate = $request->input('end_date');

//     return Excel::download(new AttendanceSabhaExport($startDate, $endDate), 'attendance_sabha_report.xlsx');
// }

// public function zeroAttendanceReport(Request $request)
// {
//     $startDate = $request->input('start_date', now()->startOfMonth()->toDateString());
//     $endDate = $request->input('end_date', now()->endOfMonth()->toDateString());

//     $reportData = $this->generateAttendanceReport($startDate, $endDate); // your real logic here

//     $filteredData = collect($reportData)->filter(function ($item) {
//         return (float) $item['percentage'] == 0;
//     })->values();

//     return view('admin.reports.attendance-zero', [
//         'reportData' => $filteredData,
//         'startDate' => $startDate,
//         'endDate' => $endDate
//     ]);
// }




    public function zeroAttendanceReport(Request $request)
    {
        $startDate = $request->input('start_date', now()->startOfMonth()->toDateString());
        $endDate = $request->input('end_date', now()->endOfMonth()->toDateString());

        $reportData = $this->generateAttendanceReport($startDate, $endDate);

        // Filter only members with 0% attendance
        $filteredData = collect($reportData)->filter(function ($row) {
            return (float) $row['raw_percentage'] === 0.0;
        })->values();

        return view('admin.reports.attendance-zero', [
            'reportData' => $filteredData,
            'startDate' => $startDate,
            'endDate' => $endDate
        ]);
    }

    // private function generateAttendanceReport($startDate, $endDate)
    // {
    //     $members = Member::with(['mandalDetails', 'statusDetails'])->get();
    //     $reportData = [];

    //     foreach ($members as $index => $member) {
    //         $age = $member->dob ? Carbon::parse($member->dob)->age : null;

    //         $organisedCount = Sabha::whereBetween('date', [$startDate, $endDate])->count();

    //         $attendedSabhaIds = Attendance::where('member_id', $member->id)
    //             ->whereBetween('created_at', [$startDate, $endDate])
    //             ->pluck('sabha_id');

    //         $attendedCount = $attendedSabhaIds->count();

    //         $attendedTitles = Sabha::whereIn('id', $attendedSabhaIds)->pluck('title')->implode(', ');

    //         $rawPercentage = $organisedCount > 0 ? ($attendedCount / $organisedCount) * 100 : 0;
    //         $percentage = round($rawPercentage, 2) . '%';

    //         $reportData[] = [
    //             'sr_no' => $index + 1,
    //             'member_id' => $member->id,
    //             'first_name' => $member->first_name,
    //             'last_name' => $member->last_name,
    //             'gender' => $member->gender,
    //             'mobile_no' => $member->number,
    //             'age' => $age,
    //             'karyakarta' => $member->Karyakarta,
    //             'mandal' => $member->mandalDetails->title ?? 'N/A',
    //             'status' => $member->statusDetails->title ?? 'N/A',
    //             'organised' => $organisedCount,
    //             'attended' => $attendedCount,
    //             'attended_titles' => $attendedTitles,
    //             'percentage' => $percentage,
    //             'raw_percentage' => $rawPercentage,
    //         ];
    //     }

    //     return $reportData;
    // }
    private function generateAttendanceReport($startDate, $endDate)
{
    $members = Member::with(['mandalDetails', 'statusDetails'])->get();

    // Sabhas organized in this date range
    $organisedSabhas = Sabha::whereBetween('date', [$startDate, $endDate])->get();
    $organisedSabhaIds = $organisedSabhas->pluck('id');
    $organisedCount = $organisedSabhas->count();

    $reportData = [];

    foreach ($members as $index => $member) {
        $age = $member->dob ? Carbon::parse($member->dob)->age : null;

        // Get attended sabhas in date range, but only those in organised sabhas
        $attendedSabhaIds = Attendance::where('member_id', $member->id)
            ->whereBetween('created_at', [$startDate, $endDate])
            ->whereIn('sabha_id', $organisedSabhaIds)
            ->pluck('sabha_id');

        $attendedCount = $attendedSabhaIds->count();

        // Titles of sabhas attended by this member
        $attendedTitles = Sabha::whereIn('id', $attendedSabhaIds)->pluck('title')->implode(', ');

        // Calculate % only if any sabha is organized
        $rawPercentage = $organisedCount > 0 ? ($attendedCount / $organisedCount) * 100 : 0;
        $percentage = round($rawPercentage, 2) . '%';

        $reportData[] = [
            'sr_no' => $index + 1,
            'member_id' => $member->id,
            'first_name' => $member->first_name,
            'last_name' => $member->last_name,
            'gender' => $member->gender,
            'mobile_no' => $member->number,
            'age' => $age,
            'karyakarta' => $member->Karyakarta,
            'mandal' => $member->mandalDetails->title ?? 'N/A',
            'status' => $member->statusDetails->title ?? 'N/A',
            'organised' => $organisedCount,
            'attended' => $attendedCount,
            'attended_titles' => $attendedTitles,
            'percentage' => $percentage,
            'raw_percentage' => $rawPercentage, // for internal filter
        ];
    }

    return $reportData;
}




//  public function zeroAttendanceReport(Request $request)
//     {
//         $startDate = $request->input('start_date', now()->startOfMonth()->toDateString());
//         $endDate = $request->input('end_date', now()->endOfMonth()->toDateString());

//         $reportData = $this->generateAttendanceReport($startDate, $endDate);

//         $filteredData = collect($reportData)->filter(function ($row) {
//             return (float) $row['raw_percentage'] === 0.0;
//         })->values();

//         return view('admin.reports.attendance-zero', [
//             'reportData' => $filteredData,
//             'startDate' => $startDate,
//             'endDate' => $endDate
//         ]);
//     }

    public function exportZeroAttendance(Request $request)
    {
        $startDate = $request->input('start_date', now()->startOfMonth()->toDateString());
        $endDate = $request->input('end_date', now()->endOfMonth()->toDateString());

        $reportData = $this->generateAttendanceReport($startDate, $endDate);

        $filteredData = collect($reportData)->filter(function ($row) {
            return (float) $row['raw_percentage'] === 0.0;
        })->values();

        return Excel::download(new ZeroAttendanceExport($filteredData), 'zero_attendance_report.xlsx');
    }

    // private function generateAttendanceReport($startDate, $endDate)
    // {
    //     $members = Member::with(['mandalDetails', 'statusDetails'])->get();

    //     $organisedSabhas = Sabha::whereBetween('date', [$startDate, $endDate])->get();
    //     $organisedSabhaIds = $organisedSabhas->pluck('id');
    //     $organisedCount = $organisedSabhas->count();

    //     $reportData = [];

    //     foreach ($members as $index => $member) {
    //         $age = $member->dob ? Carbon::parse($member->dob)->age : null;

    //         $attendedSabhaIds = Attendance::where('member_id', $member->id)
    //             ->whereBetween('created_at', [$startDate, $endDate])
    //             ->whereIn('sabha_id', $organisedSabhaIds)
    //             ->pluck('sabha_id');

    //         $attendedCount = $attendedSabhaIds->count();

    //         $attendedTitles = Sabha::whereIn('id', $attendedSabhaIds)->pluck('title')->implode(', ');

    //         $rawPercentage = $organisedCount > 0 ? ($attendedCount / $organisedCount) * 100 : 0;
    //         $percentage = round($rawPercentage, 2) . '%';

    //         $reportData[] = [
    //             'sr_no' => $index + 1,
    //             'member_id' => $member->id,
    //             'first_name' => $member->first_name,
    //             'last_name' => $member->last_name,
    //             'gender' => $member->gender,
    //             'mobile_no' => $member->number,
    //             'age' => $age,
    //             'karyakarta' => $member->Karyakarta,
    //             'mandal' => $member->mandalDetails->title ?? 'N/A',
    //             'status' => $member->statusDetails->title ?? 'N/A',
    //             'organised' => $organisedCount,
    //             'attended' => $attendedCount,
    //             'attended_titles' => $attendedTitles,
    //             'percentage' => $percentage,
    //             'raw_percentage' => $rawPercentage,
    //         ];
    //     }

    //     return $reportData;
    // }

}
