<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Sabha;
use Illuminate\Http\Request;

class SabhaController extends Controller
{
    // GET: Fetch all mandals
    public function index()
    {
        $mandals = Sabha::all();
        return response()->json($mandals);
    }

    // POST: Create a new mandal
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        $mandal = Sabha::create($request->all());

        return response()->json(['message' => 'Sabha created successfully', 'mandal' => $mandal], 201);
    }

    // GET: Fetch a single mandal
    public function show($id)
    {
        $mandal = Sabha::find($id);

        if (!$mandal) {
            return response()->json(['message' => 'Sabha not found'], 404);
        }

        return response()->json($mandal);
    }

    // PUT: Update an existing mandal
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        $mandal = Sabha::find($id);

        if (!$mandal) {
            return response()->json(['message' => 'Sabha not found'], 404);
        }

        $mandal->update($request->all());

        return response()->json(['message' => 'Sabha updated successfully', 'mandal' => $mandal]);
    }

    // DELETE: Remove a mandal
    public function destroy($id)
    {
        $mandal = Sabha::find($id);

        if (!$mandal) {
            return response()->json(['message' => 'Sabha not found'], 404);
        }

        $mandal->delete();

        return response()->json(['message' => 'Sabha deleted successfully']);
    }
}
