<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany; // If Sabha has many related records
use Illuminate\Database\Eloquent\Relations\BelongsTo; // If Sabha belongs to another record
use Illuminate\Database\Eloquent\Relations\BelongsToMany; // If Sabha has a many-to-many relationship
use TCG\Voyager\Models\Attendance;

class Sabha extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'sabhas'; // Laravel infers 'sabh' from 'Sabha', but explicit is good

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'id'; // Default, but explicitly set if different



    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',

        'date',

        // Add other fields from your sabhas table here
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'date' => 'datetime', // Example: cast a date field to a datetime object
        // 'is_active' => 'boolean', // Example: cast a boolean field
    ];
    protected $hidden = [
        'created_at',
        'updated_at',
    ];
}
