<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use TCG\Voyager\Facades\Voyager;
use App\Actions\CardAction;
use App\Actions\PdfAction;
use App\Actions\WhatsappAction;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);
        Voyager::addAction(\App\Actions\CardAction::class);
        Voyager::addAction(\App\Actions\PdfAction::class);
        Voyager::addAction(\App\Actions\WhatsappAction::class);
    }
}
