<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Attendance Report Export</title>
</head>
<body>
    <table border="1" cellspacing="0" cellpadding="5">
        <thead>
            <tr>
                <th>SR No</th>
                <th>Member ID</th>
                <th>Name</th>
                <th>Gender</th>
                <th>Mobile</th>
                <th>Age</th>
                <th>Karyakarta</th>
                <th>Mandal</th>
                <th>Status</th>
                @foreach($attendanceDates as $date)
                    <th>{{ \Carbon\Carbon::parse($date)->format('d-m-Y') }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach($members as $index => $member)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $member->id }}</td>
                    <td>{{ $member->first_name }} {{ $member->last_name }}</td>
                    <td>{{ $member->gender }}</td>
                    <td>{{ $member->number }}</td>
                    <td>{{ $member->age }} years</td>
                    <td>{{ $member->Karyakarta }}</td>
                    <td>{{ $member->mandalDetails->title ?? 'N/A' }}</td>
                    <td>{{ $member->statusDetails->title ?? 'N/A' }}</td>
                    @foreach($attendanceDates as $date)
                        @php
                            $present = $member->attendances->firstWhere('date', $date);
                        @endphp
                        <td>{{ $present ? 'Present' : 'Absent' }}</td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
