@extends('voyager::master')

@section('content')
<div class="container-fluid">
    <h3 style="color: #fff;">0% Attendance Report</h3>

   <form method="GET" action="{{ route('admin.reports.attendance.zero') }}" class="mb-4">
    <div class="row">
        <div class="col-md-3">
            <label style="color: #fff;">Start Date</label>
            <input type="date" name="start_date" class="form-control" value="{{ $startDate }}">
        </div>
        <div class="col-md-3">
            <label style="color: #fff;">End Date</label>
            <input type="date" name="end_date" class="form-control" value="{{ $endDate }}">
        </div>
    </div>

    <button type="submit" class="btn btn-success mt-3">Filter</button>
    <a href="{{ route('admin.reports.attendance.zero') }}" class="btn btn-danger mt-3">Clear</a>
    <a href="{{ route('admin.reports.attendance.zero.export', ['start_date' => $startDate, 'end_date' => $endDate]) }}"
       class="btn btn-primary mt-3">Export to Excel</a>
</form>


    <div class="table-responsive">
        <table class="table table-bordered table-striped" style="background: #fff;">
            <thead>
                <tr>
                    <th>SR. No</th>
                    <th>Member ID</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Gender</th>
                    <th>Mobile Number</th>
                    <th>Age</th>
                    <th>Karyakarta</th>
                    <th>Mandal</th>
                    <th>Status</th>
                    <th>No. of Sabha Organised</th>
                    <th>No. of Sabha Attended</th>
                    <th>Sabha Names Attended</th>
                    <th>% of Sabha Attended</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($reportData as $row)
                    <tr>
                        <td>{{ $row['sr_no'] }}</td>
                        <td>{{ $row['member_id'] }}</td>
                        <td>{{ $row['first_name'] }}</td>
                        <td>{{ $row['last_name'] }}</td>
                        <td>{{ $row['gender'] }}</td>
                        <td>{{ $row['mobile_no'] }}</td>
                        <td>{{ $row['age'] }}</td>
                        <td>{{ $row['karyakarta'] }}</td>
                        <td>{{ $row['mandal'] }}</td>
                        <td>{{ $row['status'] }}</td>
                        <td>{{ $row['organised'] }}</td>
                        <td>{{ $row['attended'] }}</td>
                        <td>{{ $row['attended_titles'] }}</td>
                        <td>{{ $row['percentage'] }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="14" class="text-center">No members with 0% attendance found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
