<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Member extends Model
{
    use HasFactory;

    protected $table = 'members';

    public $timestamps = false;
    
    protected $fillable = [
        'first_name',
        'last_name',
        'member_image',
        'number',
        'gender',
        'dob',
        'age',
        'address',
        'city',
        'mandal',
        'status',
        'Karyakarta',
    ];

    // Relationship with MemberStatus
    public function statusDetails()
    {
        return $this->belongsTo(MemberStatus::class, 'status');
    }

    // Relationship with Mandal
    public function mandalDetails()
    {
        return $this->belongsTo(Mandal::class, 'mandal');
    }

    public function getAgeAttribute()
    {
        return \Carbon\Carbon::parse($this->dob)->age;
    }

}
