<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Membership Card</title>
    <style>
        .id-card {
            width: 350px;
            background: #F8F1E4;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            position: relative;
            font-family: Arial, sans-serif;
            margin: auto;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .brand-logo {
            width: 80px;
            margin-top: 10px;
        }

        .profile-container {
            position: relative;
            margin-top: 20px;
        }

        .profile-pic {
            width: 110px;
            height: 110px;
            border-radius: 50%;
            object-fit: cover;
            border: 5px solid white;
        }

        .member-name {
            font-size: 18px;
            font-weight: bold;
            background: #C69C32;
            color: white;
            padding: 10px 20px;
            border-radius: 20px;
            display: inline-block;
            margin: 10px 0;
        }

        .memberid-label {
            font-weight: bold;
            color: #C69C32;
            font-size: 16px;
        }

        .member-id {
            font-size: 16px;
            color: #333;
            font-weight: bold;
        }

        .qr-code {
            width: 100px;
            background: white;
            padding: 5px;
            border-radius: 8px;
            margin-top: 10px;
        }

        .print-button {
            margin-top: 15px;
            background: #C69C32;
            color: white;
            border-radius: 5px;
            padding: 8px 12px;
            text-decoration: none;
            display: inline-block;
        }

    </style>
</head>
<body>
    <div class="id-card">
        <div>
            <!-- Logo -->
            <img src="{{ public_path('storage/' . setting('admin.icon_image')) }}" alt="Brand Logo" class="brand-logo">

            <!-- Profile Picture -->
            <div class="profile-container">
                <img src="{{ public_path('storage/' . $member->member_image) }}" class="profile-pic" alt="Member Image">
            </div>

            <!-- Name -->
            <h5 class="member-name">{{ $member->first_name }} {{ $member->last_name }}</h5>

            <!-- Mobile Number -->
            <p><span class="memberid-label">Member ID : </span> <span class="member-id">{{ $member->id }}</span></p>

            <!-- QR Code -->
            <img src="data:image/svg+xml;base64,{{ base64_encode(QrCode::format('svg')->size(150)->generate(url('/api/scan-attendance?member_id='.$member->id))) }}" class="qr-code" alt="QR Code">

        </div>
    </div>
</body>
</html>