<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;
use App\Http\Controllers\Api\MemberController;
use App\Http\Controllers\Api\MandalController;
use App\Http\Controllers\Api\MemberStatusController;
use App\Http\Controllers\Api\AttendanceController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\SabhaController;

// Public route for login
Route::post('/login', [AuthController::class, 'login']);

// Protected routes using Sanctum middleware
Route::middleware('auth:sanctum')->group(function () {
    // Get the authenticated user
    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    // Logout route
    Route::post('/logout', [AuthController::class, 'logout']);
});

// Attendances
Route::prefix('attendances')->group(function () {
    Route::get('/', [AttendanceController::class, 'index']);
    Route::post('/', [AttendanceController::class, 'store']);
    Route::get('/{id}', [AttendanceController::class, 'show']);
    Route::put('/{id}', [AttendanceController::class, 'update']);
    Route::delete('/{id}', [AttendanceController::class, 'destroy']);
    // Route::post('/mark', [AttendanceController::class, 'markAttendance']);
    Route::match(['get', 'post'], '/mark', [AttendanceController::class, 'markAttendance']);
});

// Members
Route::prefix('members')->group(function () {
    Route::get('/', [MemberController::class, 'index']);
    Route::post('/', [MemberController::class, 'store']);
    Route::post('/{id}', [MemberController::class, 'update']);
    Route::delete('/{id}', [MemberController::class, 'destroy']);
    Route::get('/cards', [MemberController::class, 'getAllMemberCards']);
});


Route::prefix('sabhas')->group(function () {
    Route::get('/', [SabhaController::class, 'index']);
    // Route::post('/', [SabhaController::class, 'store']);
    Route::post('/{id}', [SabhaController::class, 'update']);
    Route::delete('/{id}', [SabhaController::class, 'destroy']);
});

// Mandals
Route::prefix('mandals')->group(function () {
    Route::get('/', [MandalController::class, 'index']);
    Route::post('/', [MandalController::class, 'store']);
    Route::get('/{id}', [MandalController::class, 'show']);
    Route::put('/{id}', [MandalController::class, 'update']);
    Route::delete('/{id}', [MandalController::class, 'destroy']);
});

// Member Statuses
Route::prefix('member-statuses')->group(function () {
    Route::get('/', [MemberStatusController::class, 'index']);
    Route::post('/', [MemberStatusController::class, 'store']);
    Route::get('/{id}', [MemberStatusController::class, 'show']);
    Route::put('/{id}', [MemberStatusController::class, 'update']);
    Route::delete('/{id}', [MemberStatusController::class, 'destroy']);
});

// QR Code Attendance Scan
Route::get('/scan-attendance', function (Request $request) {
    $memberId = $request->query('member_id');

    if (!$memberId) {
        return response()->json(['error' => 'Member ID is required'], 400);
    }

    // Send POST request to mark attendance
    $response = Http::post(url('/api/attendances/mark'), [
        'member_id' => $memberId,
    ]);

    // return $response->json();
    return $response->json()['message'];
});
