<?php $__env->startSection('content'); ?>

<div class="container">

    <h2>Attendance Report</h2>

    <form method="GET" action="<?php echo e(route('attendance.report')); ?>" class="mb-4">

        <div class="row">

            <div class="col-md-4">

                <label>Start Date</label>

                <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">

            </div>

            <div class="col-md-4">

                <label>End Date</label>

                <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">

            </div>

            <div class="col-md-4">

                <label>Member</label>

                <select name="member_id" class="form-control">

                    <option value="">All Members</option>

                    <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <option value="<?php echo e($member->id); ?>" <?php echo e(request('member_id') == $member->id ? 'selected' : ''); ?>>
                        <?php echo e($member->first_name . ' ' . $member->last_name); ?>

                    </option>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </select>

            </div>

        </div>

        <button type="submit" class="btn btn-success mt-3">Filter</button>

        <a href="<?php echo e(route('attendance.report')); ?>" class="btn btn-danger mt-3">Clear Filter</a>

    </form>



    <table class="table table-bordered">

        <thead>

            <tr>

                <th>Date</th>

                <th>Member Name</th>

            </tr>

        </thead>

        <tbody>

            <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <tr>

                <td><?php echo e($attendance->date); ?></td>

                <td><?php echo e($attendance->memberDetails->first_name ?? 'N/A'); ?></td>

            </tr>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>

    </table>

    

    <?php echo e($attendances->links()); ?>


</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('voyager::master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/mywebcbh/attendance.mywebapp.co.in/resources/views/admin/attendance-report.blade.php ENDPATH**/ ?>