<?php $__env->startSection('content'); ?>
<style>
    .id-card {
        width: 350px;
        background: #F8F1E4;
        border-radius: 15px;
        padding: 20px;
        text-align: center;
        position: relative;
        font-family: Arial, sans-serif;
        margin: auto;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        overflow: hidden;
    }
    /* Golden diagonal corner */
    .id-card::before {
        content: "";
        position: absolute;
        top: 0;
        right: 0;
        width: 100px;
        height: 100px;
        background: #C69C32;
        clip-path: polygon(100% 0, 0% 0%, 100% 100%);
    }

    .id-card::after {
        content: "";
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100px;
        height: 100px;
        background: #C69C32;
        clip-path: polygon(0% 100%, 0% 0%, 100% 100%);
    }

    .brand-logo {
        width: 80px;
        margin-top: 10px;
    }

    .profile-container {
        position: relative;
        margin-top: 20px;
    }

    .profile-pic {
        width: 110px;
        height: 110px;
        border-radius: 50%;
        object-fit: cover;
        border: 5px solid white;
    }

    .member-name {
        font-size: 18px;
        font-weight: bold;
        background: #C69C32;
        color: white;
        padding: 10px 20px;
        border-radius: 20px;
        display: inline-block;
        margin: 10px 0;
    }

    .memberid-label {
        font-weight: bold;
        color: #C69C32;
        font-size: 16px;
    }

    .member-id {
        font-size: 16px;
        color: #333;
        font-weight: bold;
    }

    .qr-code {
        width: 100px;
        background: white;
        padding: 5px;
        border-radius: 8px;
        margin-top: 10px;
    }

    .print-button {
        margin-top: 15px;
        background: #C69C32;
        color: white;
        border-radius: 5px;
        padding: 8px 12px;
        text-decoration: none;
        display: inline-block;
    }

</style>

<div class="id-card">
    <div>
         <!-- Logo -->
        <img src="<?php echo e(Voyager::image(setting('admin.icon_image'))); ?>" alt="Brand Logo" class="brand-logo">

        <!-- Profile Picture -->
        <div class="profile-container">
            <img src="<?php echo e(asset('storage/' . $member->member_image)); ?>" class="profile-pic" alt="Member Image">
        </div>

        <!-- Name -->
        <h5 class="member-name"><?php echo e($member->first_name); ?> <?php echo e($member->last_name); ?></h5>

        <!-- Mobile Number -->
        <p><span class="memberid-label">Member ID : </span> <span class="member-id"><?php echo e($member->id); ?></span></p>

        <!-- QR Code -->
        <img src="data:image/svg+xml;base64,<?php echo e(base64_encode(QrCode::format('svg')->size(150)->generate(url('/api/scan-attendance?member_id='.$member->id)))); ?>" class="qr-code" alt="QR Code">

        <!-- Print Button -->
        <br>
        <a href="<?php echo e(url('/download-card/' . $member->id)); ?>" class="print-button">Download PDF</a>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('voyager::master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/mywebcbh/attendance.mywebapp.co.in/resources/views/admin/members/card.blade.php ENDPATH**/ ?>