<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Sabha;

class Attendance extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'member_id',
        'sabha_id',
    ];

    //hidden
    protected $hidden = [
        'created_at',
        'updated_at',
        'sabha_id',
        'member_id',
    ];
    // Relationship with Member
    public function memberDetails()
    {
        return $this->belongsTo(Member::class, 'member_id', 'id');
    }

    public function sabhaDetails()
    {
        return $this->belongsTo(Sabha::class, 'sabha_id', 'id');
    }
}
