<?php

namespace App\Actions;

use TCG\Voyager\Actions\AbstractAction;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;

class WhatsappAction extends AbstractAction
{
    public function getTitle()
    {
        return 'Send WhatsApp';
    }

    public function getIcon()
    {
        return 'voyager-chat'; // Adjust the icon as needed
    }

    public function getAttributes()
    {
        return [
            'class' => 'btn btn-sm btn-success',
        ];
    }

    public function getDefaultRoute()
    {
        return route('admin.send.whatsapp', ['id' => $this->data->id]);
    }

    public function shouldActionDisplayOnRow($data)
    {
        return true; // Show button for all rows
    }

    public function shouldActionDisplayOnDataType()
    {
        return $this->dataType->slug == 'members'; // Adjust if necessary
    }
}
