<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use TCG\Voyager\Models\Attendance;
use TCG\Voyager\Models\Member;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index(Request $request)
    {
        $query = Attendance::query()->with('memberDetails');

        // Apply filters if provided
        if ($request->filled('start_date') && $request->filled('end_date')) {
            $query->whereBetween('date', [$request->start_date, $request->end_date]);
        }

        if ($request->filled('member_id')) {
            $query->where('member_id', $request->member_id);
        }

        $attendances = $query->paginate(10);
        $members = Member::all();

        return view('admin.attendance-report', compact('attendances', 'members'));
    }
}
