<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use TCG\Voyager\Models\MemberStatus;
use Illuminate\Http\Request;

class MemberStatusController extends Controller
{
    // GET: Fetch all member statuses
    public function index()
    {
        $statuses = MemberStatus::all();
        return response()->json($statuses);
    }

    // POST: Create a new member status
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        $status = MemberStatus::create($request->all());

        return response()->json(['message' => 'Member status created successfully', 'status' => $status], 201);
    }

    // GET: Fetch a specific member status
    public function show($id)
    {
        $status = MemberStatus::find($id);

        if (!$status) {
            return response()->json(['message' => 'Member status not found'], 404);
        }

        return response()->json($status);
    }

    // PUT: Update an existing member status
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        $status = MemberStatus::find($id);

        if (!$status) {
            return response()->json(['message' => 'Member status not found'], 404);
        }

        $status->update($request->all());

        return response()->json(['message' => 'Member status updated successfully', 'status' => $status]);
    }

    // DELETE: Remove a member status
    public function destroy($id)
    {
        $status = MemberStatus::find($id);

        if (!$status) {
            return response()->json(['message' => 'Member status not found'], 404);
        }

        $status->delete();

        return response()->json(['message' => 'Member status deleted successfully']);
    }
}
