<?php

namespace App\Http\Controllers\Voyager;

use TCG\Voyager\Http\Controllers\VoyagerBaseController;
use TCG\Voyager\Models\Member;
use PDF;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;

class MembersController extends VoyagerBaseController
{
    // Override the store method
    public function store(Request $request)
    {
        // First, let Voyager handle the default store operation
        $response = parent::store($request);
        
        // Get the newly created member
        $member = Member::orderBy('id', 'desc')->first();
        
        // Generate and send the card
        $this->generateAndSendCard($member);
        
        return $response;
    }
    
    // Override the update method
    public function update(Request $request, $id)
    {
        // First, let Voyager handle the default update operation
        $response = parent::update($request, $id);
        
        // Get the updated member
        $member = Member::findOrFail($id);
        
        // Generate and send the card
        $this->generateAndSendCard($member);
        
        return $response;
    }
    
    // Helper method to generate PDF and send via WhatsApp
    protected function generateAndSendCard($member)
    {
        try {
            // Generate the PDF
            $pdf = PDF::loadView('pdf.card', compact('member'));

            // Store the PDF
            $pdfPath = 'pdfs/membership_card_' . $member->id . '.pdf';
            Storage::disk('public')->put($pdfPath, $pdf->output());

            // Get the public URL
            $pdfUrl = Storage::disk('public')->url($pdfPath);
    
            // Send via WhatsApp
            $this->sendWhatsAppDocument($member->number, $pdfUrl);
            
        } catch (\Exception $e) {
            // Log any errors
            \Log::error('Failed to generate/send membership card: ' . $e->getMessage());
        }
    }
    
    // WhatsApp sending function
    private function sendWhatsAppDocument($number, $pdfUrl)
    {
        $response = Http::post('http://wa.rigelpay.in/api/v1/sendDocument', [
            'key' => 'e4613dac2c8e428e9b327cd79c61669a',
            'to' => $number,
            'url' => $pdfUrl,
            'filename' => 'membership_card.pdf'
        ]);

        $responseData = $response->json();

        if ($response->successful() && isset($responseData['ErrorCode']) && $responseData['ErrorCode'] === '000') {
            \Log::info('WhatsApp document sent', ['member_id' => $number, 'api_reference' => $responseData['Data'] ?? null]);
        } else {
            \Log::error('WhatsApp API error', [
                'member_id' => $number, 
                'error_code' => $responseData['ErrorCode'] ?? 'Unknown', 
                'error_message' => $responseData['ErrorMessage'] ?? 'No message returned'
            ]);
        }
    }
}