<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\WhatsappController;
use App\Http\Controllers\Api\MemberController;
use Illuminate\Support\Facades\Artisan;
use Barryvdh\DomPDF\PDF;
use Illuminate\Support\Facades\App;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();
    Route::get('/attendance-report', [ReportController::class, 'index'])->name('attendance.report');
    Route::get('/members/{id}/card', [MemberController::class, 'generateCard'])->name('admin.members.card');
    Route::get('/send-whatsapp/{id}', [WhatsappController::class, 'sendMessage'])->name('admin.send.whatsapp');
});

Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    return "Cache cleared!";
});

Route::get('/download-card/{id}', function ($id, PDF $pdf) {
    $member = \TCG\Voyager\Models\Member::findOrFail($id);

    $pdf = App::make(PDF::class);
    $pdf->loadView('pdf.card', compact('member'));

    return $pdf->download('membership_card.pdf');
});