<?php

// namespace App\Exports;

// use App\Models\AppModelsMember;
// use Maatwebsite\Excel\Concerns\FromCollection;

// class MemberReportExport implements FromCollection
// {
//     /**
//     * @return \Illuminate\Support\Collection
//     */
//     public function collection()
//     {
//         return AppModelsMember::all();
//     }
// }


namespace App\Exports;

use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class MemberReportExport implements FromCollection, WithHeadings
{
    protected $memberId;

    public function __construct($memberId = null)
    {
        $this->memberId = $memberId;
    }

    public function collection()
    {
        $query = Member::with(['mandalDetails', 'statusDetails']);

        if ($this->memberId) {
            $query->where('id', $this->memberId);
        }

        return $query->get()->map(function ($member) {
            return [
                $member->id,
                $member->first_name,
                $member->last_name,
                $member->gender,
                $member->number,
                $member->dob,
                $member->age,
                $member->address,
                $member->city,
                $member->Karyakarta,
                optional($member->mandalDetails)->title,
                optional($member->statusDetails)->title,
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Member ID',
            'First Name',
            'Last Name',
            'Gender',
            'Mobile',
            'DOB',
            'Age',
            'Address',
            'City',
            'Karyakarta',
            'Mandal',
            'Status',
        ];
    }
}