<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ZeroAttendanceExport implements FromCollection, WithHeadings
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        return $this->data->map(function ($row) {
            return [
                $row['sr_no'],
                $row['member_id'],
                $row['first_name'],
                $row['last_name'],
                $row['gender'],
                $row['mobile_no'],
                $row['age'],
                $row['karyakarta'],
                $row['mandal'],
                $row['status'],
                $row['organised'],
                $row['attended'],
                $row['attended_titles'],
                $row['percentage'],
            ];
        });
    }

    public function headings(): array
    {
        return [
            'SR. No',
            'Member ID',
            'First Name',
            'Last Name',
            'Gender',
            'Mobile Number',
            'Age',
            'Karyakarta',
            'Mandal',
            'Status',
            'No. of Sabha Organised',
            'No. of Sabha Attended',
            'Sabha Names Attended',
            '% of Sabha Attended',
        ];
    }
}
