<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Mandal;
use Illuminate\Http\Request;

class MandalController extends Controller
{
    // GET: Fetch all mandals
    public function index()
    {
        $mandals = Mandal::all();
        return response()->json($mandals);
    }

    // POST: Create a new mandal
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        $mandal = Mandal::create($request->all());

        return response()->json(['message' => 'Mandal created successfully', 'mandal' => $mandal], 201);
    }

    // GET: Fetch a single mandal
    public function show($id)
    {
        $mandal = Mandal::find($id);

        if (!$mandal) {
            return response()->json(['message' => 'Mandal not found'], 404);
        }

        return response()->json($mandal);
    }

    // PUT: Update an existing mandal
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        $mandal = Mandal::find($id);

        if (!$mandal) {
            return response()->json(['message' => 'Mandal not found'], 404);
        }

        $mandal->update($request->all());

        return response()->json(['message' => 'Mandal updated successfully', 'mandal' => $mandal]);
    }

    // DELETE: Remove a mandal
    public function destroy($id)
    {
        $mandal = Mandal::find($id);

        if (!$mandal) {
            return response()->json(['message' => 'Mandal not found'], 404);
        }

        $mandal->delete();

        return response()->json(['message' => 'Mandal deleted successfully']);
    }
}
