@extends('voyager::master')

@section('content')
<div class="page-content container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-bordered">
                <div class="panel-body">
                    <form id="attendance-form" method="POST" action="{{ route('admin.attendances.custom-store') }}">
                        @csrf

                        <!-- Member Search -->
                        <div class="form-group">
                            <label>Search Member (by ID or Mobile)</label>
                            <input type="text" id="member-search" class="form-control" placeholder="Enter member ID or mobile number">
                            <div id="member-results" class="mt-2" style="display:none;">
                                <select id="member-select" class="form-control" name="member_id" required>
                                    <option value="">Select a member</option>
                                </select>
                            </div>
                        </div>

                        <!-- Selected Member Info -->
                        <div id="member-info" class="alert alert-info" style="display:none;">
                            <strong>Selected:</strong>
                            <span id="member-name"></span> | 
                            <span id="member-mandal"></span> | 
                            <span id="member-mobile"></span>
                        </div>

                        <!-- Date Field -->
                        <div class="form-group">
                            <label>Date</label>
                            <input type="date" name="date" class="form-control" required>
                        </div>

                        <!-- Sabha Field -->
                        <div class="form-group">
                            <label>Sabha</label>
                            <select name="sabha_id" class="form-control" required>
                                @foreach(\App\Models\Sabha::all() as $sabha)
                                    <option value="{{ $sabha->id }}">{{ $sabha->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@section('javascript')
<script>
$(document).ready(function() {
    // Member search functionality
    $('#member-search').on('input', function() {
        if($(this).val().length > 2) {
            $.get('/admin/attendances/search-member', {search: $(this).val()}, function(data) {
                if(data.length > 0) {
                    $('#member-select').empty().append('<option value="">Select a member</option>');
                    data.forEach(function(member) {
                        $('#member-select').append(
                            `<option value="${member.id}" 
                              data-name="${member.first_name} ${member.last_name}"
                              data-mandal="${member.mandal_details ? member.mandal_details.title : 'No Mandal'}"
                              data-mobile="${member.number}">
                                ${member.first_name} ${member.last_name} (${member.number}) - ${member.mandal_details ? member.mandal_details.title : 'No Mandal'}
                            </option>`
                        );
                    });
                    $('#member-results').show();
                }
            });
        }
    });

    // Member selection handler
    $('#member-select').change(function() {
        if($(this).val()) {
            $('#member-name').text($(this).find(':selected').data('name'));
            $('#member-mandal').text($(this).find(':selected').data('mandal'));
            $('#member-mobile').text($(this).find(':selected').data('mobile'));
            $('#member-info').show();
        } else {
            $('#member-info').hide();
        }
    });
});
</script>
<style>
#member-results {
    border: 1px solid #ddd;
    border-radius: 4px;
    padding: 10px;
    background: #f9f9f9;
}
#member-select option {
    padding: 8px;
}
</style>
@endsection
@endsection