@extends('voyager::master')
@section('content')
<style>
    body {
        background-color: #fbe6d3;
    }

    .id-card {
        width: 320px;
        background: #fbe6d3;
        border-radius: 10px;
        padding: 20px 15px;
        text-align: center;
        font-family: 'Arial', sans-serif;
        margin: 20px auto;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        position: relative;
    }

    .top-logo {
        width: 100px;
        margin: 0 auto 10px;
    }

    .title {
        font-size: 20px;
        font-weight: bold;
        color: #7a3e13;
        /* margin-bottom: 10px; */
    }

    .profile-circle {
        width: 120px;
        height: 120px;
        background-color: #a84900;
        border-radius: 50%;
        margin: 15px auto;
        overflow: hidden;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .profile-pic {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .member-name {
        font-size: 15px;
        font-weight: bold;
        color: #7a3e13;
        /* margin-top: 10px; */
    }

    .member-id {
        font-size: 12px;
        color: #7a3e13;
        /* margin-top: 4px; */
    }

    .mandal-name {
        font-size: 14px;
        font-weight: bold;
        color: #7a3e13;
        margin-top: 8px;
    }

    .decor-img {
        margin: 10px auto;
        width: 100%;
        max-width: 300px;
    }

    .qr-code {
        margin-top: 10px;
        width: 140px;
        background: #fbe6d3;
        padding: 6px;
        border: 1px solid #7a3e13;
        border-radius: 6px;
    }

    .print-button {
        margin-top: 15px;
        background: #a84900;
        color: white;
        border-radius: 5px;
        padding: 8px 12px;
        text-decoration: none;
        border: none;
        cursor: pointer;
    }
</style>

<div class="id-card" id="card">
    <!-- Top Emblem/Logo -->
    <img src="{{ Voyager::image(setting('admin.icon_image')) }}" class="top-logo" alt="Logo">

    <!-- Title -->
    <!-- <div class="title">SATSANG ID CARD</div> -->

    <!-- Profile Circle -->
    <div class="profile-circle">
        <img src="{{ asset('storage/' . $member->member_image) }}" class="profile-pic" alt="Profile Picture">
    </div>

    <!-- Member Info -->
    <div class="title">{{ $member->first_name }} {{ $member->last_name }}</div>
    <div class="member-id">ID: {{ $member->id }}</div>

    <!-- Mandal Name -->
    <!-- <div class="mandal-name">
        {{ $member->mandal ?? 'MANDAL NAME' }}
    </div> -->

  <div class="member-name">
    {{ $member->mandalDetails->title ?? 'MANDAL NAME' }}
</div>


    <!-- Decorative Line -->
    <img src="{{ asset('storage/decor-line.png') }}" alt="Decoration" class="decor-img">

    <!-- QR Code -->
    <img src="data:image/svg+xml;base64,{{ base64_encode(
        QrCode::format('svg')
            ->size(200)
            ->margin(0)
            ->color(138, 49, 0)
            ->generate(url('/api/scan-attendance?member_id=' . $member->id))
    ) }}" class="qr-code" alt="QR Code">

    <!-- Two Custom Images -->
    <img src="{{ asset('storage/line.png') }}" alt="Line 1" style="margin-top: 10px; max-width: 200px;">
    <!-- <img src="{{ asset('storage/line.png') }}" alt="Line 2" style="margin-top: 5px; max-width: 180px;"> -->

    <br>

    <!-- Download Button -->
    <button onclick="downloadCardAsImage()" class="print-button">Download Card</button>
</div>
@endsection

@section('javascript')
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
    function downloadCardAsImage() {
        const card = document.getElementById('card');
        html2canvas(card, {
            scale: 3,
            useCORS: true
        }).then(canvas => {
            const link = document.createElement('a');
            link.download = 'satsang_id_card.jpg';
            link.href = canvas.toDataURL('image/jpeg', 1.0);
            link.click();
        });
    }
</script>
@endsection
