@extends('voyager::master')

@section('content')
<div class="container">
    <h2 style="color: #fff;">Member Report by Gender</h2>

    <form method="GET" action="{{ route('admin.reports.gender') }}" class="mb-4">
    <div class="row">
        <div class="col-md-4">
            <label style="color: #fff;">Select Gender</label>
            <select name="gender" class="form-control">
                <option value="">All Genders</option>
                <option value="Male" {{ request('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                <option value="Female" {{ request('gender') == 'Female' ? 'selected' : '' }}>Female</option>
            </select>
        </div>
    </div>
    <button type="submit" class="btn btn-success mt-3">Filter</button>
    <a href="{{ route('admin.reports.gender') }}" class="btn btn-danger mt-3">Clear</a>

    <!-- ✅ Export Button -->
    <a href="{{ route('admin.reports.gender.export', ['gender' => request('gender')]) }}" class="btn btn-primary mt-3">
        Export to Excel
    </a>
</form>


    @if(count($selectedMembers) > 0)
        <table class="table table-bordered table-striped" style="background: #fff;">
            <thead>
                <tr>
                    <th>SR No</th>
                    <th>Member ID</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Member Image</th>
                    <th>Gender</th>
                    <th>Number</th>
                    <th>Dob</th>
                    <th>Age</th>
                    <th>Address</th>
                    <th>City</th>
                    <th>Karyakarta</th>
                    <th>Mandal</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($selectedMembers as $index => $member)
                <tr>
                    <td>{{ $index + 1 }}</td> <!-- SR No -->
                    <td>{{ $member->id }}</td> <!-- Member ID -->
                    <td>{{ $member->first_name }}</td>
                    <td>{{ $member->last_name }}</td>
                    <td>
                        @if($member->member_image)
                            <img src="{{ asset('storage/' . $member->member_image) }}" width="60">
                        @else
                            No Image
                        @endif
                    </td>
                    <td>{{ $member->gender }}</td>
                    <td>{{ $member->number }}</td>
                    <!-- <td>{{ $member->dob }}</td> -->
                     <td>{{ \Carbon\Carbon::parse($member->dob)->format('d-m-Y') }}</td>
                    <td>{{ $member->age }} years</td>
                    <td>{{ $member->address }}</td>
                    <td>{{ $member->city }}</td>
                    <td>{{ $member->Karyakarta }}</td>
                    <td>{{ optional($member->mandalDetails)->title ?? 'N/A' }}</td>
                    <td>{{ optional($member->statusDetails)->title ?? 'N/A' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>No member data found.</p>
    @endif
</div>
@endsection
