<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\WhatsappController;
use App\Http\Controllers\Api\MemberController;
use Illuminate\Support\Facades\Artisan;
use Barryvdh\DomPDF\PDF;
use Illuminate\Support\Facades\App;
use App\Models\Member;
use App\Exports\MemberReportExport;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\MandalMemberExport;
use App\Exports\GenderMemberExport;
use App\Exports\AgeMemberExport;
use App\Exports\KaryakartaMemberExport;
use App\Exports\StatusMemberExport;
use App\Exports\AttendanceSabhaExport;
// use App\Http\Controllers\AttendanceReportController;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();

    // Attendance routes
    Route::get('/attendance-report', [ReportController::class, 'index'])->name('attendance.report');

    // Member routes
    Route::get('/members/{id}/card', [MemberController::class, 'generateCard'])->name('admin.members.card');
    Route::get('/send-whatsapp/{id}', [WhatsappController::class, 'sendMessage'])->name('admin.send.whatsapp');


    Route::get('/members/{id}', function ($id) {
        $member = \App\Models\Member::with('mandalDetails')->find($id);
        return response()->json($member);
    })->name('voyager.members.get');


    Route::post('/util/autocomplete', [\App\Http\Controllers\Api\AttendanceController::class, 'search'])
        ->name('voyager.members.search');
});

// Report routes
Route::get('/admin/reports/members', [ReportController::class, 'membersReport'])->name('admin.reports.members');
Route::get('/admin/reports/mandal', [ReportController::class, 'mandalReport'])->name('admin.reports.mandal');
Route::get('/admin/reports/gender', [ReportController::class, 'genderReport'])->name('admin.reports.gender');
Route::get('/admin/reports/age', [ReportController::class, 'ageReport'])->name('admin.reports.age');
Route::get('/admin/reports/karyakarta', [ReportController::class, 'karyakartaReport'])->name('admin.reports.karyakarta');
Route::get('/admin/reports/status', [ReportController::class, 'statusReport'])->name('admin.reports.status');
Route::get('admin/reports/attendance_sabha', [ReportController::class, 'attendanceSabhaReport'])->name('admin.reports.attendance.sabha');
Route::get('admin/reports/attendance', [ReportController::class, 'attendanceReport'])->name('admin.reports.attendance');
// Route::get('admin/reports/attendance_zero', [ReportController::class, 'zeroAttendanceReport'])->name('admin.reports.attendance.zero');
Route::get('admin/reports/zero_attendance', [ReportController::class, 'zeroAttendanceReport'])->name('admin.reports.attendance.zero');



// Export routes
Route::get('/admin/reports/members/export', function () {
    $memberId = request('member_id');
    return Excel::download(new MemberReportExport($memberId), 'member_report.xlsx');
})->name('admin.reports.members.export');

Route::get('/admin/reports/mandal/export', function () {
    $mandal = request('mandal');
    return Excel::download(new MandalMemberExport($mandal), 'mandal_member_report.xlsx');
})->name('admin.reports.mandal.export');

Route::get('/admin/reports/gender/export', function () {
    $gender = request('gender');
    return Excel::download(new GenderMemberExport($gender), 'gender_member_report.xlsx');
})->name('admin.reports.gender.export');

Route::get('/admin/reports/age/export', function () {
    $startAge = request('start_age');
    $endAge = request('end_age');
    return Excel::download(new AgeMemberExport($startAge, $endAge), 'age_member_report.xlsx');
})->name('admin.reports.age.export');

Route::get('/admin/reports/karyakarta/export', function () {
    $karyakarta = request('karyakarta');
    return Excel::download(new KaryakartaMemberExport($karyakarta), 'karyakarta_member_report.xlsx');
})->name('admin.reports.karyakarta.export');

Route::get('/admin/reports/status/export', function () {
    $status = request('status');
    return Excel::download(new StatusMemberExport($status), 'status_member_report.xlsx');
})->name('admin.reports.status.export');


Route::get('admin/reports/zero_attendance/export', [ReportController::class, 'exportZeroAttendance'])
    ->name('admin.reports.attendance.zero.export');


// Route::get('/admin/reports/attendance-sabha/export', [AttendanceReportController::class, 'export'])->name('admin.reports.attendance.sabha.export');
Route::get('admin/reports/attendance/sabha/export', [ReportController::class, 'exportAttendanceSabha'])->name('admin.reports.attendance.sabha.export');
Route::get('admin/reports/attendance/export', [ReportController::class, 'exportAttendance'])->name('admin.reports.attendance.export');


// Cache clearing route
Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    return "Cache cleared!";
});

// PDF card download route
Route::get('/download-card/{id}', function ($id, PDF $pdf) {
    $member = \App\Models\Member::findOrFail($id);
    $pdf = App::make(PDF::class);
    $pdf->loadView('pdf.card', compact('member'));
    $pdf->setPaper([0, 0, 370, 550], 'portrait');
    return $pdf->download('membership_card.pdf');
});
