<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 style="color: #fff;">Attendance Report - All Members (Date-wise)</h2>

    <form method="GET" action="<?php echo e(route('admin.reports.attendance')); ?>" class="mb-4">
        <div class="row">
            <div class="col-md-3">
                <label style="color: #fff;">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
            </div>
            <div class="col-md-3">
                <label style="color: #fff;">End Date</label>
                <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
            </div>
        </div>
        <div class="mt-3">
            <button type="submit" class="btn btn-success">Filter</button>
            <a href="<?php echo e(route('admin.reports.attendance')); ?>" class="btn btn-danger">Clear</a>

            
            <a href="<?php echo e(route('admin.reports.attendance.export', ['start_date' => request('start_date'), 'end_date' => request('end_date')])); ?>" class="btn btn-primary">
                Export to Excel
            </a>
        </div>
    </form>

    <?php if(count($members) > 0): ?>
        <div class="table-responsive mt-4">
            <table class="table table-bordered" style="background: #fff;">
                <thead>
                    <tr>
                        <th>SR No</th>
                        <th>Member ID</th>
                        <th>Name</th>
                        <th>Gender</th>
                        <th>Mobile</th>
                        <th>Age</th>
                        <th>Karyakarta</th>
                        <th>Mandal</th>
                        <th>Status</th>
                        <?php $__currentLoopData = $attendanceDates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e(\Carbon\Carbon::parse($date)->format('d-m-Y')); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($member->id); ?></td>
                            <td><?php echo e($member->first_name); ?> <?php echo e($member->last_name); ?></td>
                            <td><?php echo e($member->gender); ?></td>
                            <td><?php echo e($member->number); ?></td>
                            <td><?php echo e($member->age); ?> years</td>
                            <td><?php echo e($member->Karyakarta); ?></td>
                            <td><?php echo e($member->mandalDetails->title ?? 'N/A'); ?></td>
                            <td><?php echo e($member->statusDetails->title ?? 'N/A'); ?></td>
                            <?php $__currentLoopData = $attendanceDates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $present = $member->attendances->firstWhere('date', $date);
                                ?>
                                <td><?php echo e($present ? 'Present' : 'Absent'); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p class="mt-4">No attendance data found for the selected filters.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('voyager::master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u241073935/domains/click4demos.co.in/public_html/attendance/resources/views/admin/reports/attendance.blade.php ENDPATH**/ ?>